/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.encoding;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml1.binding.encoding.BaseSAML1MessageEncoder;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class HTTPPostEncoder
extends BaseSAML1MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPPostEncoder.class);
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;

    public HTTPPostEncoder(VelocityEngine engine, String templateId) {
        this.velocityEngine = engine;
        this.velocityTemplateId = templateId;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this encoder only support SAMLMessageContext");
            throw new MessageEncodingException("Invalid message context type, this encoder only support SAMLMessageContext");
        }
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Object outboundMessage = samlMsgCtx.getOutboundSAMLMessage();
        if (outboundMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL(samlMsgCtx).buildURL();
        if (samlMsgCtx.getOutboundSAMLMessage() instanceof ResponseAbstractType) {
            ((ResponseAbstractType)samlMsgCtx.getOutboundSAMLMessage()).setRecipient(endpointURL);
        }
        this.signMessage(samlMsgCtx);
        samlMsgCtx.setOutboundMessage((XMLObject)outboundMessage);
        this.postEncode(samlMsgCtx, endpointURL);
    }

    protected void postEncode(SAMLMessageContext messageContext, String endpointURL) throws MessageEncodingException {
        this.log.debug("Invoking velocity template to create POST body");
        try {
            VelocityContext context = new VelocityContext();
            Encoder esapiEncoder = ESAPI.encoder();
            String encodedEndpointURL = esapiEncoder.encodeForHTMLAttribute(endpointURL);
            this.log.debug("Encoding action url of '{}' with encoded value '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
            context.put("action", (Object)encodedEndpointURL);
            context.put("binding", (Object)this.getBindingURI());
            this.log.debug("Marshalling and Base64 encoding SAML message");
            String messageXML = XMLHelper.nodeToString((Node)this.marshallMessage((XMLObject)messageContext.getOutboundSAMLMessage()));
            String encodedMessage = Base64.encodeBytes((byte[])messageXML.getBytes("UTF-8"), (int)8);
            context.put("SAMLResponse", (Object)encodedMessage);
            if (messageContext.getRelayState() != null) {
                String encodedRelayState = esapiEncoder.encodeForHTMLAttribute(messageContext.getRelayState());
                this.log.debug("Setting TARGET parameter to: '{}', encoded as '{}'", (Object)messageContext.getRelayState(), (Object)encodedRelayState);
                context.put("TARGET", (Object)encodedRelayState);
            }
            HTTPOutTransport outTransport = (HTTPOutTransport)messageContext.getOutboundMessageTransport();
            HTTPTransportUtils.addNoCacheHeaders((HTTPOutTransport)outTransport);
            HTTPTransportUtils.setUTF8Encoding((HTTPOutTransport)outTransport);
            HTTPTransportUtils.setContentType((HTTPOutTransport)outTransport, (String)"text/html");
            OutputStream transportOutStream = outTransport.getOutgoingStream();
            OutputStreamWriter out = new OutputStreamWriter(transportOutStream, "UTF-8");
            this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
            ((Writer)out).flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant.");
            throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
        }
        catch (Exception e) {
            this.log.error("Error invoking velocity template", (Throwable)e);
            throw new MessageEncodingException("Error creating output document", e);
        }
    }
}

