/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.validation.ValidatorSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Configuration {
    private static QName defaultProvider = new QName("http://www.opensaml.org/xmltooling-config", "DEFAULT");
    private static Map<QName, Element> configuredObjectProviders = new ConcurrentHashMap<QName, Element>(0);
    private static Map<String, Element> validatorSuiteConfigurations = new ConcurrentHashMap<String, Element>(0);
    private static XMLObjectBuilderFactory builderFactory = new XMLObjectBuilderFactory();
    private static MarshallerFactory marshallerFactory = new MarshallerFactory();
    private static UnmarshallerFactory unmarshallerFactory = new UnmarshallerFactory();
    private static Map<String, ValidatorSuite> validatorSuites = new ConcurrentHashMap<String, ValidatorSuite>(5);
    private static Set<QName> idAttributeNames = new CopyOnWriteArraySet<QName>();
    private static SecurityConfiguration globalSecurityConfig;
    private static ParserPool parserPool;

    protected Configuration() {
    }

    public static ParserPool getParserPool() {
        return parserPool;
    }

    public static void setParserPool(ParserPool newParserPool) {
        parserPool = newParserPool;
    }

    public static QName getDefaultProviderQName() {
        return defaultProvider;
    }

    public static void registerObjectProvider(QName providerName, XMLObjectBuilder builder, Marshaller marshaller, Unmarshaller unmarshaller) {
        Logger log = Configuration.getLogger();
        log.debug("Registering new builder, marshaller, and unmarshaller for {}", (Object)providerName);
        builderFactory.registerBuilder(providerName, builder);
        marshallerFactory.registerMarshaller(providerName, marshaller);
        unmarshallerFactory.registerUnmarshaller(providerName, unmarshaller);
    }

    public static void deregisterObjectProvider(QName key) {
        Logger log = Configuration.getLogger();
        log.debug("Unregistering builder, marshaller, and unmarshaller for {}", (Object)key);
        configuredObjectProviders.remove(key);
        builderFactory.deregisterBuilder(key);
        marshallerFactory.deregisterMarshaller(key);
        unmarshallerFactory.deregisterUnmarshaller(key);
    }

    public static XMLObjectBuilderFactory getBuilderFactory() {
        return builderFactory;
    }

    public static MarshallerFactory getMarshallerFactory() {
        return marshallerFactory;
    }

    public static UnmarshallerFactory getUnmarshallerFactory() {
        return unmarshallerFactory;
    }

    public static void registerValidatorSuite(String suiteId, ValidatorSuite suite) {
        validatorSuites.put(suiteId, suite);
    }

    public static void deregisterValidatorSuite(String suiteId) {
        validatorSuiteConfigurations.remove(suiteId);
        validatorSuites.remove(suiteId);
    }

    public static ValidatorSuite getValidatorSuite(String suiteId) {
        return validatorSuites.get(suiteId);
    }

    public static void registerIDAttribute(QName attributeName) {
        if (!idAttributeNames.contains(attributeName)) {
            idAttributeNames.add(attributeName);
        }
    }

    public static void deregisterIDAttribute(QName attributeName) {
        if (idAttributeNames.contains(attributeName)) {
            idAttributeNames.remove(attributeName);
        }
    }

    public static boolean isIDAttribute(QName attributeName) {
        return idAttributeNames.contains(attributeName);
    }

    public static SecurityConfiguration getGlobalSecurityConfiguration() {
        return globalSecurityConfig;
    }

    public static void setGlobalSecurityConfiguration(SecurityConfiguration config) {
        globalSecurityConfig = config;
    }

    public static void validateNonSunJAXP() {
        Logger log = Configuration.getLogger();
        String builderFactoryClass = DocumentBuilderFactory.newInstance().getClass().getName();
        log.debug("VM using JAXP parser {}", (Object)builderFactoryClass);
        if (builderFactoryClass.startsWith("com.sun")) {
            String errorMsg = "\n\n\nOpenSAML requires an xml parser that supports JAXP 1.3 and DOM3.\nThe JVM is currently configured to use the Sun XML parser, which is known\nto be buggy and can not be used with OpenSAML.  Please endorse a functional\nJAXP library(ies) such as Xerces and Xalan.  For instructions on how to endorse\na new parser see http://java.sun.com/j2se/1.5.0/docs/guide/standards/index.html\n\n\n";
            log.error(errorMsg);
            throw new Error(errorMsg);
        }
    }

    public static boolean validateJCEProviders() {
        Logger log = Configuration.getLogger();
        boolean ret = true;
        String errorMsgAESPadding = "The JCE providers currently configured in the JVM do not support\nrequired capabilities for XML Encryption, either the 'AES' cipher algorithm\nor the 'ISO10126Padding' padding scheme\n";
        try {
            Cipher.getInstance("AES/CBC/ISO10126Padding");
        }
        catch (NoSuchAlgorithmException e) {
            log.warn(errorMsgAESPadding);
            ret = false;
        }
        catch (NoSuchPaddingException e) {
            log.warn(errorMsgAESPadding);
            ret = false;
        }
        return ret;
    }

    public static void registerObjectProvider(QName providerName, XMLObjectBuilder builder, Marshaller marshaller, Unmarshaller unmarshaller, Element configuration) {
        Logger log = Configuration.getLogger();
        log.debug("Registering new builder, marshaller, and unmarshaller for {}", (Object)providerName);
        if (configuration != null) {
            configuredObjectProviders.put(providerName, configuration);
        }
        builderFactory.registerBuilder(providerName, builder);
        marshallerFactory.registerMarshaller(providerName, marshaller);
        unmarshallerFactory.registerUnmarshaller(providerName, unmarshaller);
    }

    public static Element getObjectProviderConfiguration(QName qualifedName) {
        Element configElement = configuredObjectProviders.get(qualifedName);
        if (configElement != null) {
            return (Element)configElement.cloneNode(true);
        }
        return null;
    }

    public static void registerValidatorSuite(String suiteId, ValidatorSuite suite, Element configuration) {
        if (configuration != null) {
            validatorSuiteConfigurations.put(suiteId, configuration);
        }
        validatorSuites.put(suiteId, suite);
    }

    public static Element getValidatorSuiteConfiguration(String suiteId) {
        Element configElement = validatorSuiteConfigurations.get(suiteId);
        if (configElement != null) {
            return (Element)configElement.cloneNode(true);
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(Configuration.class);
    }

    static {
        Configuration.validateJCEProviders();
        Configuration.registerIDAttribute(new QName("http://www.w3.org/XML/1998/namespace", "id"));
    }
}

