/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IgnoreAllErrorHandler
implements ErrorHandler {
    private static Logger log = LoggerFactory.getLogger(IgnoreAllErrorHandler.class);
    private static final boolean warnOnExceptions = System.getProperty("org.apache.xml.security.test.warn.on.exceptions", "false").equals("true");
    private static final boolean throwExceptions = System.getProperty("org.apache.xml.security.test.throw.exceptions", "false").equals("true");

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.warn("", (Throwable)ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.error("", (Throwable)ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.warn("", (Throwable)ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }
}

