/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.as.embedded.EmbeddedStandAloneServerFactory;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.as.embedded.StandaloneServerIndirection;
import org.jboss.as.embedded.logging.EmbeddedLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EmbeddedServerFactory {
    private static final String MODULE_ID_EMBEDDED = "org.jboss.as.embedded";
    private static final String MODULE_ID_LOGMANAGER = "org.jboss.logmanager";
    private static final String MODULE_ID_VFS = "org.jboss.vfs";
    private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_LOGMANAGER = "java.util.logging.manager";
    private static final String SYSPROP_KEY_JBOSS_HOME_DIR = "jboss.home.dir";
    private static final String SYSPROP_KEY_JBOSS_MODULES_DIR = "jboss.modules.dir";
    private static final String SYSPROP_KEY_JBOSS_BUNDLES_DIR = "jboss.bundles.dir";
    private static final String SYSPROP_VALUE_JBOSS_LOGMANAGER = "org.jboss.logmanager.LogManager";

    private EmbeddedServerFactory() {
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String bundlePath, String ... systemPackages) {
        return EmbeddedServerFactory.create(jbossHomePath, modulePath, bundlePath, systemPackages, null);
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String bundlePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = jbossHomeDir.getAbsolutePath() + File.separator + "modules";
        }
        if (bundlePath == null) {
            bundlePath = jbossHomeDir.getAbsolutePath() + File.separator + "bundles";
        }
        return EmbeddedServerFactory.create(EmbeddedServerFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, bundlePath, cmdargs);
    }

    public static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir) {
        String bundlePath = jbossHomeDir.getAbsolutePath() + File.separator + "bundles";
        return EmbeddedServerFactory.create(moduleLoader, jbossHomeDir, bundlePath, new String[0]);
    }

    private static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir, String bundlePath, String[] cmdargs) {
        Object standaloneServerImpl;
        Method createServerMethod;
        Class standaloneServerClass;
        Class embeddedServerFactoryClass;
        Module embeddedModule;
        EmbeddedServerFactory.setupBundlePath(bundlePath);
        EmbeddedServerFactory.setupVfsModule(moduleLoader);
        EmbeddedServerFactory.setupLoggingSystem(moduleLoader);
        WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_HOME_DIR, (String)jbossHomeDir.getAbsolutePath());
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedServerFactoryClass = embeddedModuleCL.loadClass(EmbeddedStandAloneServerFactory.class.getName());
            standaloneServerClass = embeddedModuleCL.loadClass(StandaloneServer.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, EmbeddedStandAloneServerFactory.class.getName());
        }
        try {
            createServerMethod = embeddedServerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedServerFactoryClass.getName());
        }
        try {
            Properties sysprops = WildFlySecurityManager.getSystemPropertiesPrivileged();
            Map sysenv = WildFlySecurityManager.getSystemEnvironmentPrivileged();
            String[] args = cmdargs != null ? cmdargs : new String[]{};
            standaloneServerImpl = createServerMethod.invoke(null, jbossHomeDir, moduleLoader, sysprops, sysenv, args);
        }
        catch (InvocationTargetException ite) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(ite.getCause(), createServerMethod);
        }
        catch (IllegalAccessException iae) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(iae, createServerMethod);
        }
        return new StandaloneServerIndirection(standaloneServerClass, standaloneServerImpl);
    }

    private static String trimPathToModulesDir(String modulePath) {
        int index = modulePath.indexOf(File.pathSeparator);
        return index == -1 ? modulePath : modulePath.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader setupModuleLoader(String modulePath, String ... systemPackages) {
        assert (modulePath != null) : "modulePath not null";
        WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_MODULES_DIR, (String)EmbeddedServerFactory.trimPathToModulesDir(modulePath));
        String classPath = WildFlySecurityManager.getPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH, null);
        try {
            ModuleLoader moduleLoader;
            WildFlySecurityManager.clearPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH);
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_MODULE_PATH, (String)modulePath);
            StringBuffer packages = new StringBuffer("org.jboss.modules,org.jboss.msc,org.jboss.dmr,org.jboss.threads,org.jboss.as.controller.client");
            if (systemPackages != null) {
                for (String packageName : systemPackages) {
                    packages.append("," + packageName);
                }
            }
            WildFlySecurityManager.setPropertyPrivileged((String)"jboss.modules.system.pkgs", (String)packages.toString());
            ModuleLoader moduleLoader2 = moduleLoader = Module.getBootModuleLoader();
            return moduleLoader2;
        }
        finally {
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH, (String)classPath);
        }
    }

    private static void setupBundlePath(String bundlePath) {
        if (bundlePath != null && new File(bundlePath).isDirectory()) {
            String absolutePath = new File(bundlePath).getAbsolutePath();
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_BUNDLES_DIR, (String)absolutePath);
        }
    }

    private static void setupVfsModule(ModuleLoader moduleLoader) {
        Module vfsModule;
        ModuleIdentifier vfsModuleID = ModuleIdentifier.create((String)MODULE_ID_VFS);
        try {
            vfsModule = moduleLoader.loadModule(vfsModuleID);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_VFS, moduleLoader);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupLoggingSystem(ModuleLoader moduleLoader) {
        Module logModule;
        ModuleIdentifier logModuleId = ModuleIdentifier.create((String)MODULE_ID_LOGMANAGER);
        try {
            logModule = moduleLoader.loadModule(logModuleId);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_LOGMANAGER, moduleLoader);
        }
        ModuleClassLoader logModuleClassLoader = logModule.getClassLoader();
        ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)logModuleClassLoader);
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_LOGMANAGER, (String)SYSPROP_VALUE_JBOSS_LOGMANAGER);
            Class<?> actualLogManagerClass = LogManager.getLogManager().getClass();
            if (actualLogManagerClass == LogManager.class) {
                System.err.println("Cannot not load JBoss LogManager. The LogManager has likely been accessed prior to this initialization.");
            } else {
                Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
        }
    }
}

