/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.deployment;

import javax.batch.operations.JobOperator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.batch.BatchServiceNames;

abstract class JobOperationStepHandler
implements OperationStepHandler {
    JobOperationStepHandler() {
    }

    public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ServiceController controller = context.getServiceRegistry(false).getService(BatchServiceNames.jobOperatorServiceName(address));
        JobOperator jobOperator = (JobOperator)controller.getService();
        String jobName = JobOperationStepHandler.getJobName(address);
        this.updateModel(context, context.getResult(), jobOperator, jobName);
    }

    protected abstract void updateModel(OperationContext var1, ModelNode var2, JobOperator var3, String var4) throws OperationFailedException;

    static String getJobName(PathAddress address) {
        return address.getLastElement().getValue();
    }
}

