/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.jgroups.spi.service;

import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelConnectorBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.service.Builder;

public class ChannelBuilder
implements Service<Channel>,
Builder<Channel> {
    private static final Logger LOGGER = Logger.getLogger(ChannelConnectorBuilder.class);
    private InjectedValue<ChannelFactory> factory = new InjectedValue();
    private final String name;
    private volatile Channel channel;

    public ChannelBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return ChannelServiceName.CHANNEL.getServiceName(this.name);
    }

    public ServiceBuilder<Channel> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)this).addDependency(ChannelServiceName.FACTORY.getServiceName(this.name), ChannelFactory.class, this.factory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Channel getValue() {
        return this.channel;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.channel = ((ChannelFactory)this.factory.getValue()).createChannel(this.name);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        if (LOGGER.isTraceEnabled()) {
            String output = this.channel.getProtocolStack().printProtocolSpec(true);
            LOGGER.tracef("JGroups channel %s created with configuration:\n %s", (Object)this.name, (Object)output);
        }
    }

    public void stop(StopContext context) {
        this.channel.close();
        this.channel = null;
    }
}

