/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ManagementUtil {
    static boolean isSecurityRealmReloadRequired(OperationContext context, ModelNode operation) {
        ServiceController<?> controller = ManagementUtil.getSecurityRealmService(context, operation, false);
        return ManagementUtil.isSecurityRealmReloadRequired(context, controller);
    }

    static boolean isSecurityRealmReloadRequired(OperationContext context, ServiceController<?> controller) {
        ServiceController.Substate substate;
        boolean reloadRequired = false;
        ServiceController.Substate substate2 = substate = controller == null ? null : controller.getSubstate();
        if (substate != null && substate.isRestState() && substate.getState() == ServiceController.State.UP && !context.isResourceServiceRestartAllowed()) {
            reloadRequired = true;
        }
        return reloadRequired;
    }

    static ServiceController<?> getSecurityRealmService(OperationContext context, ModelNode operation, boolean forUpdate) {
        String realmName = ManagementUtil.getSecurityRealmName(operation);
        ServiceRegistry registry = context.getServiceRegistry(forUpdate);
        ServiceName svcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName});
        return registry.getService(svcName);
    }

    static String getSecurityRealmName(ModelNode operation) {
        String realmName = null;
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"security-realm".equals(pe.getKey())) continue;
            realmName = pe.getValue();
            break;
        }
        assert (realmName != null) : "operation did not have an address that included a security-realm";
        return realmName;
    }

    static void updateUserDomainCallbackHandler(OperationContext context, ModelNode operation, boolean forRollback) {
        UserDomainCallbackHandler cbh = ManagementUtil.getUserDomainCallbackHandler(context, operation);
        if (cbh != null) {
            ModelNode userMap;
            PathAddress authAddress = ManagementUtil.getXmlAuthenticationAddress(operation);
            Resource root = forRollback ? context.getOriginalRootResource() : context.getRootResource();
            try {
                Resource authResource = root.navigate(authAddress);
                userMap = context.resolveExpressions(Resource.Tools.readModel((Resource)authResource));
            }
            catch (Exception e) {
                userMap = new ModelNode().setEmptyObject();
            }
            cbh.setUserDomain(userMap);
        }
    }

    private static PathAddress getXmlAuthenticationAddress(ModelNode operation) {
        PathAddress base = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathAddress result = null;
        for (int i = base.size() - 1; i >= 0; --i) {
            PathElement pe = base.getElement(i);
            if (!"authentication".equals(pe.getKey())) continue;
            result = base.subAddress(0, i + 1);
            break;
        }
        assert (result != null) : "operation did not point to a child of the xml authentication resource";
        return result;
    }

    private static UserDomainCallbackHandler getUserDomainCallbackHandler(OperationContext context, ModelNode operation) {
        String realmName = ManagementUtil.getSecurityRealmName(operation);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceName svcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName}).append(new String[]{"users"});
        ServiceController sc = registry.getService(svcName);
        return sc == null ? null : (UserDomainCallbackHandler)UserDomainCallbackHandler.class.cast(sc.getValue());
    }

    private ManagementUtil() {
    }
}

