/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public interface SSLIdentity {
    public SSLContext getFullContext();

    public SSLContext getTrustOnlyContext();

    public static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "ssl";

        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{SERVICE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<SSLIdentity> injector, String realmName, boolean optional) {
            ServiceBuilder.DependencyType type = optional ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED;
            sb.addDependency(type, ServiceUtil.createServiceName(realmName), SSLIdentity.class, injector);
            return sb;
        }
    }
}

