/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.dmr.ModelNode;

public class RoleMappingAdd
implements OperationStepHandler {
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    private RoleMappingAdd(WritableAuthorizerConfiguration authorizerConfiguration) {
        this.authorizerConfiguration = authorizerConfiguration;
    }

    public static OperationStepHandler create(WritableAuthorizerConfiguration authorizerConfiguration) {
        return new RoleMappingAdd(authorizerConfiguration);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String roleName = address.getLastElement().getValue().toUpperCase();
        ModelNode model = resource.getModel();
        RoleMappingResourceDefinition.INCLUDE_ALL.validateAndSet(operation, model);
        this.registerRuntimeAdd(context, roleName);
        context.stepCompleted();
    }

    private void registerRuntimeAdd(OperationContext context, final String roleName) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (context.isBooting()) {
                    RoleMappingAdd.this.authorizerConfiguration.addRoleMappingImmediate(roleName);
                } else {
                    RoleMappingAdd.this.authorizerConfiguration.addRoleMapping(roleName);
                }
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                boolean includeAll = RoleMappingResourceDefinition.INCLUDE_ALL.resolveModelAttribute(context, model).asBoolean();
                if (includeAll) {
                    RoleMappingAdd.this.authorizerConfiguration.setRoleMappingIncludeAll(roleName, includeAll);
                }
                RoleMappingAdd.this.registerRollbackHandler(context, roleName);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final String roleName) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                Object undoKey = RoleMappingAdd.this.authorizerConfiguration.removeRoleMapping(roleName);
                if (undoKey == null) {
                    context.restartRequired();
                }
            }
        });
    }
}

