/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapGroupSearcher;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class LdapGroupSearcherService
implements Service<LdapGroupSearcher> {
    private static final int searchTimeLimit = 10000;
    private final LdapGroupSearcher groupSearcher;

    private LdapGroupSearcherService(LdapGroupSearcher groupSearcher) {
        this.groupSearcher = groupSearcher;
    }

    public LdapGroupSearcher getValue() throws IllegalStateException, IllegalArgumentException {
        return this.groupSearcher;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    static Service<LdapGroupSearcher> createForGroupToPrincipal(String baseDn, String groupDnAttribute, String groupNameAttribute, String principalAttribute, boolean recursive, BaseLdapGroupSearchResource.GroupName searchBy) {
        return new LdapGroupSearcherService(new GroupToPrincipalSearcher(baseDn, groupDnAttribute, groupNameAttribute, principalAttribute, recursive, searchBy));
    }

    static Service<LdapGroupSearcher> createForPrincipalToGroup(String groupAttribute, String groupNameAttribute) {
        return new LdapGroupSearcherService(new PrincipalToGroupSearcher(groupAttribute, groupNameAttribute));
    }

    private static SearchControls createSearchControl(boolean recursive, String[] attributes) {
        SearchControls searchControls = new SearchControls();
        if (recursive) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        searchControls.setReturningAttributes(attributes);
        searchControls.setTimeLimit(10000);
        return searchControls;
    }

    private static String[] createArray(String ... elements) {
        ArrayList<String> elementList = new ArrayList<String>(elements.length);
        for (String current : elements) {
            if (current == null) continue;
            elementList.add(current);
        }
        return elementList.toArray(new String[elementList.size()]);
    }

    private static class PrincipalToGroupSearcher
    implements LdapGroupSearcher {
        private final String groupAttribute;
        private final String groupNameAttribute;

        private PrincipalToGroupSearcher(String groupAttribute, String groupNameAttribute) {
            this.groupAttribute = groupAttribute;
            this.groupNameAttribute = groupNameAttribute;
        }

        @Override
        public LdapEntry[] groupSearch(DirContext dirContext, LdapEntry entry) throws IOException, NamingException {
            HashSet<LdapEntry> foundEntries = new HashSet<LdapEntry>();
            Attributes groups = dirContext.getAttributes(entry.getDistinguishedName(), new String[]{this.groupAttribute});
            Attribute groupRef = groups.get(this.groupAttribute);
            if (groupRef != null) {
                NamingEnumeration<?> groupRefValues = groupRef.getAll();
                while (groupRefValues.hasMore()) {
                    String current = (String)groupRefValues.next();
                    String groupName = null;
                    if (this.groupNameAttribute != null) {
                        Attributes groupNameAttrs = dirContext.getAttributes(current, new String[]{this.groupNameAttribute});
                        Attribute groupNameAttr = groupNameAttrs.get(this.groupNameAttribute);
                        groupName = (String)groupNameAttr.get();
                    }
                    foundEntries.add(new LdapEntry(groupName, current));
                }
            }
            return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
        }
    }

    private static class GroupToPrincipalSearcher
    implements LdapGroupSearcher {
        private final String baseDn;
        private final String groupDnAttribute;
        private final String groupNameAttribute;
        private final String[] attributeArray;
        private final String filterString;
        private final boolean recursive;
        private final BaseLdapGroupSearchResource.GroupName searchBy;

        private GroupToPrincipalSearcher(String baseDn, String groupDnAttribute, String groupNameAttribute, String principalAttribute, boolean recursive, BaseLdapGroupSearchResource.GroupName searchBy) {
            this.baseDn = baseDn;
            this.groupDnAttribute = groupDnAttribute;
            this.groupNameAttribute = groupNameAttribute;
            this.attributeArray = LdapGroupSearcherService.createArray(new String[]{groupDnAttribute, groupNameAttribute});
            this.filterString = String.format("(%s={0})", principalAttribute);
            this.recursive = recursive;
            this.searchBy = searchBy;
        }

        @Override
        public LdapEntry[] groupSearch(DirContext dirContext, LdapEntry entry) throws IOException, NamingException {
            SearchControls searchControls = LdapGroupSearcherService.createSearchControl(this.recursive, this.attributeArray);
            HashSet<LdapEntry> foundEntries = new HashSet<LdapEntry>();
            NamingEnumeration<SearchResult> searchResults = dirContext.search(this.baseDn, this.filterString, this.getSearchParameter(entry), searchControls);
            while (searchResults.hasMore()) {
                SearchResult current = searchResults.next();
                Attributes attributes = current.getAttributes();
                if (attributes == null) continue;
                foundEntries.add(this.convertToLdapEntry(current, attributes));
            }
            return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
        }

        private LdapEntry convertToLdapEntry(SearchResult searchResult, Attributes attributes) throws NamingException {
            Attribute groupNameAttr;
            String simpleName = null;
            String distinguishedName = null;
            if (this.groupNameAttribute != null && (groupNameAttr = attributes.get(this.groupNameAttribute)) != null) {
                simpleName = (String)groupNameAttr.get();
            }
            if (this.groupDnAttribute != null) {
                if ("dn".equals(this.groupDnAttribute)) {
                    distinguishedName = searchResult.getNameInNamespace();
                } else {
                    Attribute groupDnAttr = attributes.get(this.groupDnAttribute);
                    if (groupDnAttr != null) {
                        distinguishedName = (String)groupDnAttr.get();
                    }
                }
            }
            return new LdapEntry(simpleName, distinguishedName);
        }

        private Object[] getSearchParameter(LdapEntry entry) {
            switch (this.searchBy) {
                case SIMPLE: {
                    return new String[]{entry.getSimpleName()};
                }
            }
            return new String[]{entry.getDistinguishedName()};
        }
    }
}

