/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapUserSearcher;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class LdapUserSearcherService
implements Service<LdapUserSearcher> {
    private final LdapUserSearcher searcher;
    protected static final int searchTimeLimit = 10000;

    private LdapUserSearcherService(LdapUserSearcher searcher) {
        this.searcher = searcher;
    }

    public LdapUserSearcher getValue() throws IllegalStateException, IllegalArgumentException {
        return this.searcher;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    static Service<LdapUserSearcher> createForUsernameIsDn() {
        return new LdapUserSearcherService(new LdapUserSearcher(){

            @Override
            public LdapEntry userSearch(DirContext dirContext, String suppliedName) {
                return new LdapEntry(suppliedName, suppliedName);
            }
        });
    }

    static Service<LdapUserSearcher> createForUsernameFilter(String baseDn, boolean recursive, String userDnAttribute, String attribute) {
        return new LdapUserSearcherService(new LdapUserSearcherImpl(baseDn, recursive, userDnAttribute, attribute, null));
    }

    static Service<LdapUserSearcher> createForAdvancedFilter(String baseDn, boolean recursive, String userDnAttribute, String filter) {
        return new LdapUserSearcherService(new LdapUserSearcherImpl(baseDn, recursive, userDnAttribute, null, filter));
    }

    private static class LdapUserSearcherImpl
    implements LdapUserSearcher {
        final String baseDn;
        final boolean recursive;
        final String userDnAttribute;
        final String userNameAttribute;
        final String advancedFilter;

        private LdapUserSearcherImpl(String baseDn, boolean recursive, String userDnAttribute, String userNameAttribute, String advancedFilter) {
            this.baseDn = baseDn;
            this.recursive = recursive;
            this.userDnAttribute = userDnAttribute;
            this.userNameAttribute = userNameAttribute;
            this.advancedFilter = advancedFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LdapEntry userSearch(DirContext dirContext, String suppliedName) throws IOException, NamingException {
            NamingEnumeration<SearchResult> searchEnumeration = null;
            try {
                Attribute dn;
                SearchControls searchControls = new SearchControls();
                if (this.recursive) {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing recursive search");
                    searchControls.setSearchScope(2);
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing single level search");
                    searchControls.setSearchScope(1);
                }
                searchControls.setReturningAttributes(new String[]{this.userDnAttribute});
                searchControls.setTimeLimit(10000);
                Object[] filterArguments = new Object[]{suppliedName};
                String filter = this.userNameAttribute != null ? "(" + this.userNameAttribute + "={0})" : this.advancedFilter;
                DomainManagementLogger.SECURITY_LOGGER.tracef("Searching for user '%s' using filter '%s'.", suppliedName, filter);
                searchEnumeration = dirContext.search(this.baseDn, filter, filterArguments, searchControls);
                if (!searchEnumeration.hasMore()) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in directory.", suppliedName);
                    throw DomainManagementMessages.MESSAGES.userNotFoundInDirectory(suppliedName);
                }
                String distinguishedUserDN = null;
                SearchResult result = searchEnumeration.next();
                Attributes attributes = result.getAttributes();
                if (attributes != null && (dn = attributes.get(this.userDnAttribute)) != null) {
                    distinguishedUserDN = (String)dn.get();
                }
                if (distinguishedUserDN == null) {
                    if (result.isRelative()) {
                        distinguishedUserDN = result.getName() + ("".equals(this.baseDn) ? "" : "," + this.baseDn);
                    } else {
                        String name = result.getName();
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Can't follow referral for authentication: %s", name);
                        throw DomainManagementMessages.MESSAGES.nameNotFound(suppliedName);
                    }
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("DN '%s' found for user '%s'", distinguishedUserDN, suppliedName);
                LdapEntry ldapEntry = new LdapEntry(suppliedName, distinguishedUserDN);
                return ldapEntry;
            }
            finally {
                if (searchEnumeration != null) {
                    try {
                        searchEnumeration.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
    }
}

