/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.password.LengthRestriction;
import org.jboss.as.domain.management.security.password.NoRestriction;
import org.jboss.as.domain.management.security.password.PasswordCheckResult;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordStrength;
import org.jboss.as.domain.management.security.password.PasswordStrengthCheckResult;
import org.jboss.as.domain.management.security.password.PasswordStrengthChecker;
import org.jboss.as.domain.management.security.password.RegexRestriction;
import org.jboss.as.domain.management.security.password.RestrictionLevel;
import org.jboss.as.domain.management.security.password.ValueRestriction;
import org.jboss.as.domain.management.security.password.simple.SimplePasswordStrengthChecker;

public class PasswordCheckUtil {
    public static final String _PROPERTY_CHECKER = "password.restriction.checker";
    public static final String _PROPERTY_STRENGTH = "password.restriction.strength";
    public static final String _PROPERTY_FORBIDDEN = "password.restriction.forbiddenValue";
    public static final String _PROPERTY_RESTRICTION = "password.restriction";
    public static final String _PROPERTY_MIN_LENGTH = "password.restriction.minLength";
    public static final String _PROPERTY_MIN_ALPHA = "password.restriction.minAlpha";
    public static final String _PROPERTY_MIN_DIGIT = "password.restriction.minDigit";
    public static final String _PROPERTY_MIN_SYMBOL = "password.restriction.minSymbol";
    public static final String _PROPERTY_MATCH_USERNAME = "password.restriction.mustNotMatchUsername";
    public static final PasswordCheckUtil INSTANCE = new PasswordCheckUtil();
    private PasswordStrengthChecker passwordStrengthChecker;
    private PasswordStrength acceptable = PasswordStrength.MODERATE;
    private RestrictionLevel level = RestrictionLevel.WARN;
    private boolean mustNotMatchUsername = false;
    public List<PasswordRestriction> passwordValuesRestrictions = new ArrayList<PasswordRestriction>();

    protected PasswordCheckUtil() {
        String configFilePath = System.getProperty("jboss.adduser.config");
        if (configFilePath != null) {
            try {
                Properties configProperties = new Properties();
                configProperties.load(new FileInputStream(new File(configFilePath)));
                this.initDefaultStrength(configProperties);
                this.initStrengthChecker(configProperties);
                this.initPasswordRestrictions(configProperties);
                this.initMinLength(configProperties);
                this.initMinAlpha(configProperties);
                this.initMinDigit(configProperties);
                this.initMinSymbol(configProperties);
                this.initMustNotMatchUsername(configProperties);
                this.initRestrictionLevel(configProperties);
            }
            catch (IOException e) {
                this.simple();
            }
        } else {
            this.simple();
        }
    }

    private void simple() {
        this.passwordStrengthChecker = new SimplePasswordStrengthChecker();
    }

    private void initPasswordRestrictions(Properties props) {
        try {
            String[] values;
            String forbiddens = props.getProperty(_PROPERTY_FORBIDDEN);
            if (forbiddens == null) {
                return;
            }
            for (String v : values = forbiddens.split(",")) {
                if (v == null || v.length() <= 0) continue;
                this.passwordValuesRestrictions.add(new ValueRestriction(v));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initStrengthChecker(Properties props) {
        try {
            String stringClassName = props.getProperty(_PROPERTY_CHECKER);
            if (stringClassName == null) {
                this.simple();
                return;
            }
            Class<?> clazz = Class.forName(stringClassName);
            this.passwordStrengthChecker = (PasswordStrengthChecker)clazz.newInstance();
        }
        catch (Exception e) {
            this.simple();
        }
    }

    private void initDefaultStrength(Properties props) {
        try {
            this.acceptable = PasswordStrength.valueOf(props.getProperty(_PROPERTY_STRENGTH).toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMinAlpha(Properties props) {
        try {
            int minAlpha = Integer.parseInt(props.getProperty(_PROPERTY_MIN_ALPHA));
            this.passwordValuesRestrictions.add(this.createAlphaRestriction(minAlpha));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMinSymbol(Properties props) {
        try {
            int minAlpha = Integer.parseInt(props.getProperty(_PROPERTY_MIN_SYMBOL));
            this.passwordValuesRestrictions.add(this.createSymbolRestriction(minAlpha));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMinDigit(Properties props) {
        try {
            int minDigit = Integer.parseInt(props.getProperty(_PROPERTY_MIN_DIGIT));
            this.passwordValuesRestrictions.add(this.createDigitRestriction(minDigit));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMinLength(Properties props) {
        try {
            int minLength = Integer.parseInt(props.getProperty(_PROPERTY_MIN_LENGTH));
            this.passwordValuesRestrictions.add(this.createLengthRestriction(minLength));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMustNotMatchUsername(Properties props) {
        try {
            this.mustNotMatchUsername = Boolean.parseBoolean(props.getProperty(_PROPERTY_MATCH_USERNAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initRestrictionLevel(Properties props) {
        try {
            this.level = RestrictionLevel.valueOf(props.getProperty(_PROPERTY_RESTRICTION));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean assertStrength(PasswordStrength result) {
        return result.getStrength() >= this.acceptable.getStrength();
    }

    public PasswordCheckResult check(boolean isAdminitrative, String userName, String password) {
        PasswordCheckResult.Result resultAction;
        List<PasswordRestriction> passwordValuesRestrictions = this.getPasswordRestrictions(userName);
        PasswordStrengthCheckResult strengthResult = this.passwordStrengthChecker.check(password, passwordValuesRestrictions);
        int failedRestrictions = strengthResult.getFailedRestrictions().size();
        PasswordStrength strength = strengthResult.getStrength();
        boolean strongEnough = this.assertStrength(strength);
        String resultMessage = null;
        if (isAdminitrative) {
            if (strongEnough) {
                if (failedRestrictions > 0) {
                    resultAction = PasswordCheckResult.Result.WARN;
                    resultMessage = strengthResult.getFailedRestrictions().get(0).getMessage();
                } else {
                    resultAction = PasswordCheckResult.Result.ACCEPT;
                }
            } else {
                resultAction = PasswordCheckResult.Result.WARN;
                resultMessage = DomainManagementMessages.MESSAGES.passwordNotStrongEnough(strength.toString(), this.acceptable.toString());
            }
        } else if (strongEnough) {
            if (failedRestrictions > 0) {
                resultAction = PasswordCheckResult.Result.REJECT;
                resultMessage = strengthResult.getFailedRestrictions().get(0).getMessage();
            } else {
                resultAction = PasswordCheckResult.Result.ACCEPT;
            }
        } else if (failedRestrictions > 0) {
            resultAction = PasswordCheckResult.Result.REJECT;
            resultMessage = strengthResult.getFailedRestrictions().get(0).getMessage();
        } else {
            resultAction = PasswordCheckResult.Result.REJECT;
            resultMessage = DomainManagementMessages.MESSAGES.passwordNotStrongEnough(strength.toString(), this.acceptable.toString());
        }
        return new PasswordCheckResult(resultAction, resultMessage);
    }

    public RestrictionLevel getRestrictionLevel() {
        return this.level;
    }

    public List<PasswordRestriction> getPasswordRestrictions(String userName) {
        ArrayList<PasswordRestriction> passwordValuesRestrictions = new ArrayList<PasswordRestriction>(this.passwordValuesRestrictions);
        if (this.mustNotMatchUsername) {
            passwordValuesRestrictions.add(new ValueRestriction(userName));
        }
        return passwordValuesRestrictions;
    }

    public PasswordRestriction createLengthRestriction(int minLength) {
        if (minLength <= 0) {
            return new NoRestriction();
        }
        return new LengthRestriction(minLength);
    }

    public PasswordRestriction createAlphaRestriction(int minAlpha) {
        if (minAlpha <= 0) {
            return new NoRestriction();
        }
        return this.createCharRestriction(minAlpha, "[a-zA-Z]", DomainManagementMessages.MESSAGES.passwordMustHaveAlpha(minAlpha));
    }

    public PasswordRestriction createDigitRestriction(int minDigit) {
        if (minDigit <= 0) {
            return new NoRestriction();
        }
        return this.createCharRestriction(minDigit, "[0-9]", DomainManagementMessages.MESSAGES.passwordMustHaveDigit(minDigit));
    }

    public PasswordRestriction createSymbolRestriction(int minSymbol) {
        if (minSymbol <= 0) {
            return new NoRestriction();
        }
        return this.createCharRestriction(minSymbol, "[^0-9a-zA-Z]", DomainManagementMessages.MESSAGES.passwordMustHaveSymbol(minSymbol));
    }

    private PasswordRestriction createCharRestriction(int minChar, String regex, String message) {
        if (minChar <= 0) {
            return new NoRestriction();
        }
        return new RegexRestriction(String.format("(.*%s.*){%d}", regex, minChar), message);
    }
}

