/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class FileKeystoreService
implements Service<FileKeystore> {
    private volatile FileKeystore theKeyStore;
    private final String path;
    private final char[] keystorePassword;
    private final boolean isKeyStore;
    private final String alias;
    private final char[] keyPassword;
    private final InjectedValue<String> relativeTo = new InjectedValue();

    private FileKeystoreService(String path, char[] keystorePassword, String alias, char[] keyPassword) {
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.alias = alias;
        this.keyPassword = keyPassword;
        this.isKeyStore = true;
    }

    private FileKeystoreService(String path, char[] keystorePassword) {
        this.path = path;
        this.keystorePassword = keystorePassword;
        this.alias = null;
        this.keyPassword = null;
        this.isKeyStore = false;
    }

    static FileKeystoreService newKeyStoreService(String path, char[] keystorePassword, String alias, char[] keyPassword) {
        return new FileKeystoreService(path, keystorePassword, alias, keyPassword);
    }

    static FileKeystoreService newTrustStoreService(String path, char[] keystorePassword) {
        return new FileKeystoreService(path, keystorePassword);
    }

    public void start(StartContext ctx) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        FileKeystore fileKeystore = this.isKeyStore ? FileKeystore.newKeyStore(file, this.keystorePassword, this.keyPassword, this.alias) : FileKeystore.newTrustStore(file, this.keystorePassword);
        fileKeystore.load();
        this.theKeyStore = fileKeystore;
    }

    public void stop(StopContext ctx) {
        this.theKeyStore = null;
    }

    public FileKeystore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.theKeyStore;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }
}

