/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.UndertowLogger;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.conduits.StoredResponseStreamSinkConduit;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class StoredResponse
implements ExchangeAttribute {
    public static final ExchangeAttribute INSTANCE = new StoredResponse();

    private StoredResponse() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        byte[] data = exchange.getAttachment(StoredResponseStreamSinkConduit.RESPONSE);
        if (data == null) {
            return null;
        }
        String charset = this.extractCharset(exchange.getResponseHeaders());
        if (charset == null) {
            return null;
        }
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            UndertowLogger.ROOT_LOGGER.debugf((Throwable)e, "Could not decode response body using charset %s", (Object)charset);
            return null;
        }
    }

    private String extractCharset(HeaderMap headers) {
        String contentType = headers.getFirst(Headers.CONTENT_TYPE);
        if (contentType != null) {
            String value = Headers.extractQuotedValueFromHeader(contentType, "charset");
            if (value != null) {
                return value;
            }
            if (contentType.startsWith("text/")) {
                return StandardCharsets.ISO_8859_1.displayName();
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Stored Response", newValue);
    }

    public static class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Stored Response";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals("%{STORED_RESPONSE}")) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

