/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.MaskedPassword;
import org.wildfly.security.password.interfaces.RawPassword;

final class RawMaskedPassword
extends RawPassword
implements MaskedPassword {
    private static final long serialVersionUID = -4344349209404192377L;
    private final char[] initialKeyMaterial;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] maskedPasswordBytes;
    private final byte[] initializationVector;

    RawMaskedPassword(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] maskedPasswordBytes, byte[] initializationVector) {
        super(algorithm);
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.maskedPasswordBytes = maskedPasswordBytes;
        this.initializationVector = initializationVector;
    }

    @Override
    public char[] getInitialKeyMaterial() {
        return (char[])this.initialKeyMaterial.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public byte[] getMaskedPasswordBytes() {
        return (byte[])this.maskedPasswordBytes.clone();
    }

    @Override
    public byte[] getInitializationVector() {
        return this.initializationVector == null ? null : (byte[])this.initializationVector.clone();
    }

    @Override
    public RawMaskedPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.initialKeyMaterial), Arrays.hashCode(this.salt)), Arrays.hashCode(this.maskedPasswordBytes)), this.iterationCount), Arrays.hashCode(this.initializationVector)), this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawMaskedPassword)) {
            return false;
        }
        RawMaskedPassword other = (RawMaskedPassword)obj;
        return this.iterationCount == other.iterationCount && Arrays.equals(this.initialKeyMaterial, other.initialKeyMaterial) && Arrays.equals(this.salt, other.salt) && Arrays.equals(this.maskedPasswordBytes, other.maskedPasswordBytes) && Arrays.equals(this.initializationVector, other.initializationVector) && this.getAlgorithm().equals(other.getAlgorithm());
    }
}

