/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.ParameterisedAddress;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jndi.JNDIStorable;

public class ActiveMQDestination
extends JNDIStorable
implements Destination,
Serializable {
    private static final long serialVersionUID = 5027962425462382883L;
    public static final String QUEUE_QUALIFIED_PREFIX = "queue://";
    public static final String TOPIC_QUALIFIED_PREFIX = "topic://";
    public static final String TEMP_QUEUE_QUALIFED_PREFIX = "temp-queue://";
    public static final String TEMP_TOPIC_QUALIFED_PREFIX = "temp-topic://";
    private static final char SEPARATOR = '.';
    private SimpleString simpleAddress;
    private QueueConfiguration queueConfiguration;
    @Deprecated
    private String address;
    private String name;
    private final boolean temporary;
    private final boolean queue;
    private transient TYPE thetype;
    private final transient ActiveMQSession session;
    private transient boolean created;

    private static String escape(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    void setName(String name) {
        this.name = name;
    }

    public static ActiveMQDestination createDestination(RoutingType routingType, SimpleString address) {
        if (address == null) {
            return null;
        }
        if (RoutingType.ANYCAST.equals((Object)routingType)) {
            return ActiveMQDestination.createQueue(address);
        }
        if (RoutingType.MULTICAST.equals((Object)routingType)) {
            return ActiveMQDestination.createTopic(address);
        }
        return ActiveMQDestination.fromPrefixedName(address.toString());
    }

    public static ActiveMQDestination createDestination(String name, TYPE defaultType) {
        if (name.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            return new ActiveMQQueue(name.substring(QUEUE_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TOPIC_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            return new ActiveMQQueue(name.substring(TEMP_QUEUE_QUALIFED_PREFIX.length()), true);
        }
        if (name.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TEMP_TOPIC_QUALIFED_PREFIX.length()), true);
        }
        switch (defaultType) {
            case QUEUE: {
                return new ActiveMQQueue(name);
            }
            case TOPIC: {
                return new ActiveMQTopic(name);
            }
            case TEMP_QUEUE: {
                return new ActiveMQQueue(name, true);
            }
            case TEMP_TOPIC: {
                return new ActiveMQTopic(name, true);
            }
            case DESTINATION: {
                return new ActiveMQDestination(name, TYPE.DESTINATION, null);
            }
        }
        throw new IllegalArgumentException("Invalid default destination type: " + (Object)((Object)defaultType));
    }

    public static ActiveMQDestination fromPrefixedName(String name) {
        return ActiveMQDestination.fromPrefixedName(name, name);
    }

    public static ActiveMQDestination fromPrefixedName(String addr, String name) {
        ActiveMQDestination destination;
        if (addr.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            String address = addr.substring(QUEUE_QUALIFIED_PREFIX.length());
            destination = ActiveMQDestination.createQueue(address);
        } else if (addr.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            String address = addr.substring(TOPIC_QUALIFIED_PREFIX.length());
            destination = ActiveMQDestination.createTopic(address);
        } else if (addr.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            String address = addr.substring(TEMP_QUEUE_QUALIFED_PREFIX.length());
            destination = new ActiveMQTemporaryQueue(address, null);
        } else if (addr.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            String address = addr.substring(TEMP_TOPIC_QUALIFED_PREFIX.length());
            destination = new ActiveMQTemporaryTopic(address, null);
        } else {
            destination = new ActiveMQDestination(addr, TYPE.DESTINATION, null);
        }
        return destination;
    }

    public static Destination fromPrefixed1XName(String addr, String name) {
        ActiveMQDestination destination = addr.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString()) ? ActiveMQDestination.createQueue(addr) : (addr.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString()) ? ActiveMQDestination.createTopic(addr) : (addr.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()) ? new ActiveMQTemporaryQueue(addr, null) : (addr.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()) ? new ActiveMQTemporaryTopic(addr, null) : new ActiveMQDestination(addr, TYPE.DESTINATION, null))));
        String unprefixedName = name;
        if (name.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_QUEUE_PREFIX.length());
        } else if (name.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_TOPIC_PREFIX.length());
        } else if (name.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_TEMP_QUEUE_PREFIX.length());
        } else if (name.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_TEMP_TOPIC_PREFIX.length());
        }
        destination.setName(unprefixedName);
        return destination;
    }

    public static SimpleString createQueueNameForSubscription(boolean isDurable, String clientID, String subscriptionName) {
        String queueName = clientID != null ? (isDurable ? ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName) : "nonDurable." + ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName)) : (isDurable ? ActiveMQDestination.escape(subscriptionName) : "nonDurable." + ActiveMQDestination.escape(subscriptionName));
        return SimpleString.toSimpleString(queueName);
    }

    public static String createQueueNameForSharedSubscription(boolean isDurable, String clientID, String subscriptionName) {
        if (clientID != null) {
            return (isDurable ? "Durable" : "nonDurable") + '.' + ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName);
        }
        return (isDurable ? "Durable" : "nonDurable") + '.' + ActiveMQDestination.escape(subscriptionName);
    }

    public static Pair<String, String> decomposeQueueNameForDurableSubscription(String queueName) {
        StringBuffer[] parts = new StringBuffer[2];
        int currentPart = 0;
        parts[0] = new StringBuffer();
        parts[1] = new StringBuffer();
        int pos = 0;
        while (pos < queueName.length()) {
            char ch = queueName.charAt(pos);
            ++pos;
            if (ch == '.') {
                if (++currentPart < parts.length) continue;
                throw new JMSRuntimeException("Invalid message queue name: " + queueName);
            }
            if (ch == '\\') {
                if (pos >= queueName.length()) {
                    throw new JMSRuntimeException("Invalid message queue name: " + queueName);
                }
                ch = queueName.charAt(pos);
                ++pos;
            }
            parts[currentPart].append(ch);
        }
        if (currentPart != 1) {
            parts[1] = parts[0];
            parts[0] = new StringBuffer();
        }
        Pair<String, String> pair = new Pair<String, String>(parts[0].toString(), parts[1].toString());
        return pair;
    }

    public static SimpleString createQueueAddressFromName(String name) {
        return new SimpleString(QUEUE_QUALIFIED_PREFIX + name);
    }

    public static SimpleString createTopicAddressFromName(String name) {
        return new SimpleString(TOPIC_QUALIFIED_PREFIX + name);
    }

    public static ActiveMQQueue createQueue(String address) {
        return new ActiveMQQueue(address);
    }

    public static ActiveMQQueue createQueue(SimpleString address) {
        return new ActiveMQQueue(address);
    }

    public static ActiveMQQueue createQueue(String address, String name) {
        return new ActiveMQQueue(address, name);
    }

    public static ActiveMQTopic createTopic(String address) {
        return new ActiveMQTopic(address);
    }

    public static ActiveMQTopic createTopic(SimpleString address) {
        return new ActiveMQTopic(address);
    }

    public static ActiveMQTopic createTopic(String address, String name) {
        return new ActiveMQTopic(address, name);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String address, ActiveMQSession session) {
        return new ActiveMQTemporaryQueue(address, session);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String address) {
        return ActiveMQDestination.createTemporaryQueue(address, null);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(ActiveMQSession session) {
        String address = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryQueue(address, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(ActiveMQSession session) {
        String address = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryTopic(address, session);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(ActiveMQSession session, String prefix) {
        String name = UUID.randomUUID().toString();
        String address = prefix + name;
        ActiveMQTemporaryQueue queue = ActiveMQDestination.createTemporaryQueue(address, session);
        queue.setName(name);
        return queue;
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(ActiveMQSession session, String prefix) {
        String name = UUID.randomUUID().toString();
        String address = prefix + name;
        ActiveMQTemporaryTopic topic = ActiveMQDestination.createTemporaryTopic(address, session);
        topic.setName(name);
        return topic;
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String address, ActiveMQSession session) {
        return new ActiveMQTemporaryTopic(address, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String address) {
        return ActiveMQDestination.createTemporaryTopic(address, null);
    }

    protected ActiveMQDestination(String address, TYPE type, ActiveMQSession session) {
        this(SimpleString.toSimpleString(address), type, session);
    }

    protected ActiveMQDestination(SimpleString address, TYPE type, ActiveMQSession session) {
        if (address != null) {
            this.setSimpleAddress(address);
        }
        this.thetype = type;
        this.session = session;
        this.temporary = TYPE.isTemporary(type);
        this.queue = TYPE.isQueue(type);
    }

    protected ActiveMQDestination(String address, String name, TYPE type, ActiveMQSession session) {
        this(SimpleString.toSimpleString(address), name, type, session);
    }

    @Deprecated
    protected ActiveMQDestination(SimpleString address, String name, TYPE type, ActiveMQSession session) {
        this(address, type, session);
        this.name = name;
        this.address = this.simpleAddress != null ? this.simpleAddress.toString() : null;
    }

    public void setAddress(String address) {
        this.setSimpleAddress(SimpleString.toSimpleString(address));
    }

    public String toString() {
        return "ActiveMQDestination [address=" + this.simpleAddress.toString() + ", name=" + this.name + ", type =" + (Object)((Object)this.thetype) + "]";
    }

    public void setSimpleAddress(SimpleString address) {
        if (address == null) {
            throw new IllegalArgumentException("address cannot be null");
        }
        if (ParameterisedAddress.isParameterised(address)) {
            ParameterisedAddress parameteredAddress = new ParameterisedAddress(address);
            this.simpleAddress = parameteredAddress.getAddress();
            this.address = parameteredAddress.getAddress().toString();
            this.queueConfiguration = parameteredAddress.getQueueConfiguration();
        } else {
            this.simpleAddress = address;
            this.address = address.toString();
            this.queueConfiguration = null;
        }
    }

    public void delete() throws JMSException {
        if (this.session != null) {
            boolean openedHere = false;
            ActiveMQSession sessionToUse = this.session;
            if (this.session.getCoreSession().isClosed()) {
                sessionToUse = (ActiveMQSession)this.session.getConnection().createSession();
                openedHere = true;
            }
            try {
                if (this.isQueue()) {
                    sessionToUse.deleteTemporaryQueue(this);
                } else {
                    sessionToUse.deleteTemporaryTopic(this);
                }
                this.setCreated(false);
            }
            finally {
                if (openedHere) {
                    sessionToUse.close();
                }
            }
        }
    }

    public boolean isQueue() {
        return this.queue;
    }

    public String getAddress() {
        return this.simpleAddress.toString();
    }

    public SimpleString getSimpleAddress() {
        return this.simpleAddress;
    }

    @Deprecated
    public QueueAttributes getQueueAttributes() {
        return QueueAttributes.fromQueueConfiguration(this.queueConfiguration);
    }

    public QueueConfiguration getQueueConfiguration() {
        return this.queueConfiguration;
    }

    public String getName() {
        return this.name != null ? this.name : this.getAddress();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public TYPE getType() {
        if (this.thetype == null) {
            this.thetype = this.temporary ? (this.isQueue() ? TYPE.TEMP_QUEUE : TYPE.TEMP_TOPIC) : (this.isQueue() ? TYPE.QUEUE : TYPE.TOPIC);
        }
        return this.thetype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQDestination)) {
            return false;
        }
        ActiveMQDestination that = (ActiveMQDestination)o;
        return this.simpleAddress.equals(that.simpleAddress);
    }

    public int hashCode() {
        return this.simpleAddress.hashCode();
    }

    @Override
    protected void buildFromProperties(Properties props) {
        this.setAddress(props.getProperty("address"));
    }

    @Override
    protected void populateProperties(Properties props) {
        props.put("address", this.getAddress());
    }

    public static enum TYPE {
        QUEUE,
        TOPIC,
        TEMP_QUEUE,
        TEMP_TOPIC,
        DESTINATION;


        public byte getType() {
            switch (this) {
                case QUEUE: {
                    return 0;
                }
                case TOPIC: {
                    return 1;
                }
                case TEMP_QUEUE: {
                    return 2;
                }
                case TEMP_TOPIC: {
                    return 3;
                }
                case DESTINATION: {
                    return 4;
                }
            }
            return -1;
        }

        public static TYPE getType(byte type) {
            switch (type) {
                case 0: {
                    return QUEUE;
                }
                case 1: {
                    return TOPIC;
                }
                case 2: {
                    return TEMP_QUEUE;
                }
                case 3: {
                    return TEMP_TOPIC;
                }
                case 4: {
                    return DESTINATION;
                }
            }
            return null;
        }

        public static boolean isQueue(TYPE type) {
            boolean result = false;
            if (type != null && (type.equals((Object)QUEUE) || type.equals((Object)TEMP_QUEUE))) {
                result = true;
            }
            return result;
        }

        public static boolean isTemporary(TYPE type) {
            boolean result = false;
            if (type != null && (type.equals((Object)TEMP_TOPIC) || type.equals((Object)TEMP_QUEUE))) {
                result = true;
            }
            return result;
        }
    }
}

