/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.xml;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

class PolicyExpander {
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int CAPTURE_EXPRESSION = 3;
    private static final int GOT_FILE_SEPERATOR = 4;
    public static final String ENV_START = "env.";

    PolicyExpander() {
    }

    public static String expand(String input) {
        StringBuilder valueToReturn = new StringBuilder();
        int state = 0;
        int propStart = -1;
        int i = 0;
        while (i < input.length()) {
            int ch = input.codePointAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case 36: {
                            state = 1;
                            break block0;
                        }
                    }
                    valueToReturn.appendCodePoint(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 123: {
                            state = 2;
                            break block0;
                        }
                    }
                    valueToReturn.append('$').appendCodePoint(ch);
                    state = 0;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 125: {
                            PolicyExpander.expandValue(input, valueToReturn, propStart, i);
                            state = 0;
                            break block0;
                        }
                        case 47: {
                            state = 4;
                            break block0;
                        }
                    }
                    propStart = i;
                    state = 3;
                    break;
                }
                case 3: {
                    switch (ch) {
                        case 125: {
                            PolicyExpander.expandValue(input, valueToReturn, propStart, i);
                            state = 0;
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (ch) {
                        case 125: {
                            valueToReturn.append(File.separator);
                            state = 0;
                            break block0;
                        }
                    }
                    propStart = i - 1;
                    state = 3;
                    break;
                }
            }
            i = input.offsetByCodePoints(i, 1);
        }
        String returnValue = valueToReturn.toString();
        if (returnValue.isEmpty()) {
            return null;
        }
        return returnValue;
    }

    private static void expandValue(String input, StringBuilder valueToReturn, int valueStart, int offset) {
        String value = input.substring(valueStart, offset);
        if (value.startsWith(ENV_START)) {
            String var = PolicyExpander.getEnvironmentVariable(value.substring(ENV_START.length()));
            if (var != null) {
                valueToReturn.append(var);
            }
            return;
        }
        String prop = PolicyExpander.getSystemProperty(value);
        if (prop != null) {
            valueToReturn.append(prop);
        }
    }

    private static String getEnvironmentVariable(final String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(key);
            }
        });
    }

    private static String getSystemProperty(final String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }
}

