/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.util.sso.DefaultSingleSignOn;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnEntry;
import org.wildfly.security.http.util.sso.SingleSignOn;
import org.wildfly.security.http.util.sso.SingleSignOnEntry;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DefaultSingleSignOnManager
implements SingleSignOnManager {
    private final ConcurrentMap<String, SingleSignOnEntry> cache;
    private final BiConsumer<String, SingleSignOnEntry> mutator;
    private final Supplier<String> identifierFactory;

    public DefaultSingleSignOnManager(ConcurrentMap<String, SingleSignOnEntry> cache, Supplier<String> identifierFactory) {
        this(cache, identifierFactory, (id, entry) -> {});
    }

    public DefaultSingleSignOnManager(ConcurrentMap<String, SingleSignOnEntry> cache, Supplier<String> identifierFactory, BiConsumer<String, SingleSignOnEntry> mutator) {
        this.cache = Assert.checkNotNullParam("cache", cache);
        this.mutator = Assert.checkNotNullParam("mutator", mutator);
        this.identifierFactory = Assert.checkNotNullParam("identifierFactory", identifierFactory);
    }

    @Override
    public SingleSignOn create(String mechanismName, boolean programmatic, SecurityIdentity identity) {
        String id = this.identifierFactory.get();
        DefaultSingleSignOnEntry entry = new DefaultSingleSignOnEntry(new CachedIdentity(mechanismName, programmatic, identity));
        DefaultSingleSignOn sso = new DefaultSingleSignOn(id, entry, () -> this.mutator.accept(id, entry), () -> this.cache.remove(id));
        this.cache.put(id, entry);
        return sso;
    }

    @Override
    public SingleSignOn find(String id) {
        SingleSignOnEntry entry = (SingleSignOnEntry)this.cache.get(id);
        return entry != null ? new DefaultSingleSignOn(id, entry, () -> this.mutator.accept(id, entry), () -> this.cache.remove(id)) : null;
    }
}

