/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawDigestPassword;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;

public interface DigestPassword
extends OneWayPassword {
    public static final String ALGORITHM_DIGEST_MD5 = "digest-md5";
    public static final String ALGORITHM_DIGEST_SHA = "digest-sha";
    public static final String ALGORITHM_DIGEST_SHA_256 = "digest-sha-256";
    public static final String ALGORITHM_DIGEST_SHA_384 = "digest-sha-384";
    public static final String ALGORITHM_DIGEST_SHA_512 = "digest-sha-512";
    public static final String ALGORITHM_DIGEST_SHA_512_256 = "digest-sha-512-256";

    public String getUsername();

    public String getRealm();

    public byte[] getDigest();

    @Override
    default public DigestPasswordAlgorithmSpec getParameterSpec() {
        return new DigestPasswordAlgorithmSpec(this.getUsername(), this.getRealm());
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("parameterSpec", parameterSpec);
        return parameterSpec.equals(this.getParameterSpec());
    }

    @Override
    public DigestPassword clone();

    public static DigestPassword createRaw(String algorithm, String username, String realm, byte[] digest) {
        Assert.checkNotNullParam("algorithm", algorithm);
        Assert.checkNotNullParam("username", username);
        Assert.checkNotNullParam("realm", realm);
        Assert.checkNotNullParam("digest", digest);
        return new RawDigestPassword(algorithm, username, realm, (byte[])digest.clone());
    }
}

