/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.net.URI;
import java.net.URISyntaxException;

public final class ControllerAddress {
    private final String protocol;
    private final String host;
    private final int port;
    private final int hashCode;

    public ControllerAddress(String protocol, String host, int port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.hashCode = (protocol == null ? 3 : protocol.hashCode()) * (host == null ? 5 : host.hashCode()) * port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        try {
            return new URI(this.protocol, null, this.host, this.port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            return this.protocol + "://" + this.host + ":" + this.port;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other instanceof ControllerAddress ? this.equals((ControllerAddress)other) : false;
    }

    public boolean equals(ControllerAddress other) {
        return (this.protocol == null ? other.protocol == null : this.protocol.equals(other.protocol)) && (this.host == null ? other.host == null : this.host.equals(other.host)) && this.port == other.port;
    }
}

