/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.security;

import java.security.Permission;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.modules.security.UninitializedPermission;

public final class LoadedPermissionFactory
implements PermissionFactory {
    private final ClassLoader classLoader;
    private final String className;
    private final String targetName;
    private final String permissionActions;
    private volatile Permission instance = UninitializedPermission.INSTANCE;

    public LoadedPermissionFactory(ClassLoader classLoader, String className, String targetName, String permissionActions) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        this.classLoader = classLoader;
        this.className = className;
        this.targetName = targetName;
        this.permissionActions = permissionActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Permission construct() {
        if (this.instance != UninitializedPermission.INSTANCE) {
            return this.instance;
        }
        LoadedPermissionFactory loadedPermissionFactory = this;
        synchronized (loadedPermissionFactory) {
            if (this.instance != UninitializedPermission.INSTANCE) {
                return this.instance;
            }
            try {
                Class<Permission> permissionClass = this.classLoader.loadClass(this.className).asSubclass(Permission.class);
                this.instance = PermissionFactory.constructFromClass(permissionClass, this.targetName, this.permissionActions);
                return this.instance;
            }
            catch (Throwable t) {
                this.instance = null;
                return null;
            }
        }
    }
}

