/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClassRegistry;

public abstract class AbstractClassResolver
implements ClassResolver {
    protected final boolean enforceSerialVersionUid;
    private static final SerializableClassRegistry registry = System.getSecurityManager() == null ? SerializableClassRegistry.getInstance() : AccessController.doPrivileged(new PrivilegedAction<SerializableClassRegistry>(){

        @Override
        public SerializableClassRegistry run() {
            return SerializableClassRegistry.getInstance();
        }
    });
    private static final Map<String, Class<?>> primitives;

    protected AbstractClassResolver() {
        this(false);
    }

    protected AbstractClassResolver(boolean enforceSerialVersionUid) {
        this.enforceSerialVersionUid = enforceSerialVersionUid;
    }

    protected abstract ClassLoader getClassLoader();

    @Override
    public void annotateClass(Marshaller marshaller, Class<?> clazz) throws IOException {
    }

    @Override
    public void annotateProxyClass(Marshaller marshaller, Class<?> proxyClass) throws IOException {
    }

    @Override
    public String getClassName(Class<?> clazz) throws IOException {
        return clazz.getName();
    }

    @Override
    public String[] getProxyInterfaces(Class<?> proxyClass) throws IOException {
        Class<?>[] interfaces = proxyClass.getInterfaces();
        String[] names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            names[i] = this.getClassName(interfaces[i]);
        }
        return names;
    }

    @Override
    public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
        long uid;
        Class<?> clazz = this.loadClass(name);
        if (this.enforceSerialVersionUid && serialVersionUID != 0L && (uid = registry.lookup(clazz).getEffectiveSerialVersionUID()) != serialVersionUID) {
            throw new StreamCorruptedException("serialVersionUID of " + clazz + " does not match!");
        }
        return clazz;
    }

    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> prim = primitives.get(name);
        return prim != null ? prim : Class.forName(name, false, this.getClassLoader());
    }

    @Override
    public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = this.getClassLoader();
        int length = interfaces.length;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = this.loadClass(interfaces[i]);
        }
        return Proxy.getProxyClass(classLoader, classes);
    }

    static {
        HashMap map = new HashMap();
        map.put("void", Void.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("short", Short.TYPE);
        map.put("int", Integer.TYPE);
        map.put("long", Long.TYPE);
        map.put("char", Character.TYPE);
        map.put("boolean", Boolean.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        primitives = map;
    }
}

