/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import org.jboss.marshalling.ChainedUnmarshallingFilter;
import org.jboss.marshalling.JDKSpecific;
import org.jboss.marshalling.SimpleUnmarshallingFilter;

@FunctionalInterface
public interface UnmarshallingFilter {
    public static final UnmarshallingFilter ACCEPTING = input -> FilterResponse.ACCEPT;
    public static final UnmarshallingFilter REJECTING = input -> FilterResponse.REJECT;

    public FilterResponse checkInput(JDKSpecific.FilterInput var1);

    public static enum FilterResponse {
        ACCEPT,
        REJECT,
        UNDECIDED;

    }

    public static final class Factory {
        private Factory() {
        }

        public static UnmarshallingFilter createFilter(String filterSpec) {
            return Factory.createFilter(filterSpec, false);
        }

        public static UnmarshallingFilter createFilter(String filterSpec, boolean checkJEPS290ProcessFilter) {
            UnmarshallingFilter processWide;
            UnmarshallingFilter result = new SimpleUnmarshallingFilter(filterSpec);
            if (checkJEPS290ProcessFilter && (processWide = JDKSpecific.getJEPS290ProcessWideFilter()) != null) {
                result = new ChainedUnmarshallingFilter(processWide, result);
            }
            return result;
        }
    }
}

