/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.NameCache;
import org.jgroups.util.Streamable;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Persistent Discovery Cache. Caches discovery information on disk.")
public class PDC
extends Protocol {
    protected final ConcurrentMap<Address, PhysicalAddress> cache = new ConcurrentHashMap<Address, PhysicalAddress>();
    @Property(description="The absolute path of the directory for the disk cache. The mappings will be stored as individual files in this directory")
    protected String cache_dir = File.separator + "tmp" + File.separator + "jgroups";
    protected static final String SUFFIX = ".node";
    protected File root_dir;
    protected FilenameFilter filter;

    @ManagedOperation(description="Prints the contents of the address-physical address mappings")
    public String printCache() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.cache.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return sb.toString();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.createDiskCacheFile();
        this.readCacheFromDisk();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 87: {
                Object addr = this.down_prot.down(evt);
                Address arg = (Address)evt.getArg();
                return addr != null ? addr : this.cache.get(arg);
            }
            case 102: {
                Collection addrs = (Collection)this.down_prot.down(evt);
                HashSet tmp = new HashSet(addrs);
                tmp.addAll(this.cache.values());
                return tmp;
            }
            case 88: {
                Map map = (Map)this.down_prot.down(evt);
                HashMap<Address, PhysicalAddress> new_map = new HashMap<Address, PhysicalAddress>(map);
                new_map.putAll(this.cache);
                return new_map;
            }
            case 89: {
                Tuple new_val = (Tuple)evt.getArg();
                if (new_val == null) break;
                this.cache.put((Address)new_val.getVal1(), (PhysicalAddress)new_val.getVal2());
                this.writeNodeToDisk((Address)new_val.getVal1(), (PhysicalAddress)new_val.getVal2());
                break;
            }
            case 90: {
                Address tmp_addr = (Address)evt.getArg();
                if (this.cache.remove(tmp_addr) == null) break;
                this.removeNodeFromDisk(tmp_addr);
                break;
            }
            case 6: {
                List<Address> members = ((View)evt.getArg()).getMembers();
                this.cache.keySet().stream().filter(mbr -> !members.contains(mbr)).forEach(mbr -> {
                    this.cache.remove(mbr);
                    this.removeNodeFromDisk((Address)mbr);
                });
            }
        }
        return this.down_prot.down(evt);
    }

    protected void createDiskCacheFile() throws IOException {
        this.root_dir = new File(this.cache_dir);
        if (this.root_dir.exists()) {
            if (!this.root_dir.isDirectory()) {
                throw new IllegalArgumentException("location " + this.root_dir.getPath() + " is not a directory");
            }
        } else {
            this.root_dir.mkdirs();
        }
        if (!this.root_dir.exists()) {
            throw new IllegalArgumentException("location " + this.root_dir.getPath() + " could not be accessed");
        }
        this.filter = (dir, name1) -> name1.endsWith(SUFFIX);
    }

    protected synchronized void readCacheFromDisk() {
        File[] files;
        if (this.log.isDebugEnabled()) {
            this.log.debug("reading all mappings from disk cache " + this.root_dir);
        }
        if ((files = this.root_dir.listFiles(this.filter)) == null) {
            return;
        }
        for (File file : files) {
            Mapping data = null;
            for (int i = 0; i < 3; ++i) {
                data = null;
                if (file.exists()) {
                    data = this.readAddressMapping(file);
                }
                if (data != null) break;
                Util.sleep(100L);
            }
            if (data == null) {
                this.log.warn("failed parsing content in " + file.getAbsolutePath() + ": removing it ");
                this.deleteFile(file);
                continue;
            }
            if (data == null || data.getLogicalAddr() == null || data.getPhysicalAddr() == null) continue;
            this.cache.put(data.getLogicalAddr(), (PhysicalAddress)data.getPhysicalAddr());
            if (data.getLogicalName() == null || NameCache.get(data.getLogicalAddr()) != null) continue;
            NameCache.add(data.getLogicalAddr(), data.getLogicalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Mapping readAddressMapping(File file) {
        Mapping mapping;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            Mapping mapping2 = new Mapping();
            mapping2.readFrom(in);
            mapping = mapping2;
        }
        catch (Exception e) {
            Mapping mapping3;
            try {
                this.log.debug("failed to read file : " + file.getAbsolutePath(), e);
                mapping3 = null;
            }
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
            Util.close((Closeable)in);
            return mapping3;
        }
        Util.close((Closeable)in);
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeNodeToDisk(Address logical_addr, PhysicalAddress physical_addr) {
        File destination;
        File tmpFile;
        String filename;
        block6: {
            filename = PDC.addressAsString(logical_addr);
            tmpFile = null;
            destination = null;
            tmpFile = this.writeToTempFile(this.root_dir, logical_addr, physical_addr, NameCache.get(logical_addr));
            if (tmpFile != null) break block6;
            this.deleteFile(tmpFile);
            return;
        }
        try {
            destination = new File(this.root_dir, filename + SUFFIX);
            FileChannel src_ch = new FileInputStream(tmpFile).getChannel();
            FileChannel dest_ch = new FileOutputStream(destination).getChannel();
            src_ch.transferTo(0L, src_ch.size(), dest_ch);
            src_ch.close();
            dest_ch.close();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Moved: " + tmpFile.getName() + "->" + destination.getName());
            }
            this.deleteFile(tmpFile);
        }
        catch (Exception ioe) {
            try {
                this.log.error(Util.getMessage("AttemptToMoveFailedAt") + tmpFile.getName() + "->" + destination.getName(), ioe);
                this.deleteFile(tmpFile);
            }
            catch (Throwable throwable) {
                this.deleteFile(tmpFile);
                throw throwable;
            }
        }
    }

    protected File writeToTempFile(File dir, Address logical_addr, Address physical_addr, String logical_name) throws Exception {
        DataOutputStream out = null;
        File file = null;
        String filename = null;
        try {
            file = File.createTempFile("temp", null, dir);
            filename = file.getName();
            out = new DataOutputStream(new FileOutputStream(file));
            Util.writeAddress(logical_addr, out);
            Util.writeAddress(physical_addr, out);
            Bits.writeString(logical_name, out);
            Util.close((Closeable)out);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Stored temporary file: " + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Util.close(out);
            this.log.error(Util.getMessage("FailedToWriteTemporaryFile") + filename, e);
            this.deleteFile(file);
            return null;
        }
        return file;
    }

    protected synchronized void removeNodeFromDisk(Address logical_addr) {
        String filename = PDC.addressAsString(logical_addr);
        this.deleteFile(new File(this.root_dir, filename + SUFFIX));
    }

    protected static String addressAsString(Address address) {
        if (address == null) {
            return "";
        }
        if (address instanceof UUID) {
            return ((UUID)address).toStringLong();
        }
        return address.toString();
    }

    protected boolean deleteFile(File file) {
        boolean result = true;
        if (file != null && file.exists()) {
            try {
                result = file.delete();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Deleted file result: " + file.getAbsolutePath() + " : " + result);
                }
            }
            catch (Throwable e) {
                this.log.error(Util.getMessage("FailedToDeleteFile") + file.getAbsolutePath(), e);
            }
        }
        return result;
    }

    protected static class Mapping
    implements Streamable {
        protected Address logical_addr;
        protected Address physical_addr;
        protected String logical_name;

        public Mapping() {
        }

        public Mapping(Address logical_addr, PhysicalAddress physical_addr, String logical_name) {
            this.logical_addr = logical_addr;
            this.physical_addr = physical_addr;
            this.logical_name = logical_name;
        }

        public Address getLogicalAddr() {
            return this.logical_addr;
        }

        public Address getPhysicalAddr() {
            return this.physical_addr;
        }

        public String getLogicalName() {
            return this.logical_name;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Util.writeAddress(this.logical_addr, out);
            Util.writeAddress(this.physical_addr, out);
            Bits.writeString(this.logical_name, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.logical_addr = Util.readAddress(in);
            this.physical_addr = Util.readAddress(in);
            this.logical_name = Bits.readString(in);
        }

        public String toString() {
            return this.logical_addr + ": " + this.physical_addr + " (logical name=" + this.logical_name + ")";
        }
    }
}

