/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class CapabilityReferenceCompleter
extends DefaultCompleter {
    private static final Logger log = Logger.getLogger(CapabilityReferenceCompleter.class.getName());

    public CapabilityReferenceCompleter(DefaultCompleter.CandidatesProvider provider) {
        super(provider);
    }

    public CapabilityReferenceCompleter(OperationRequestAddress address, String staticPart) {
        super(ctx -> {
            ModelNode mn;
            try {
                mn = CapabilityReferenceCompleter.toNode(address);
            }
            catch (OperationFormatException ex) {
                return Collections.emptyList();
            }
            return CapabilityReferenceCompleter.getCapabilityNames(ctx, mn, staticPart);
        });
    }

    private static ModelNode toNode(OperationRequestAddress address) throws OperationFormatException {
        if (address.isEmpty()) {
            return new ModelNode();
        }
        ModelNode mn = new ModelNode();
        for (OperationRequestAddress.Node node : address) {
            if (node.getName() != null) {
                ModelNode value = new ModelNode();
                value.set(node.getName());
                mn.add(new Property(node.getType(), value));
                continue;
            }
            throw new OperationFormatException("The node name is not specified for type '" + node.getType() + "'");
        }
        return mn;
    }

    public List<String> getCapabilityReferenceNames(CommandContext ctx, OperationRequestAddress address, String staticPart) {
        return CapabilityReferenceCompleter.getCapabilityNames(ctx, address, staticPart);
    }

    public static List<String> getCapabilityNames(CommandContext ctx, OperationRequestAddress address, String staticPart) {
        ModelNode mn;
        try {
            mn = CapabilityReferenceCompleter.toNode(address);
        }
        catch (OperationFormatException ex) {
            return Collections.emptyList();
        }
        return CapabilityReferenceCompleter.getCapabilityNames(ctx, mn, staticPart);
    }

    private static List<String> getCapabilityNames(CommandContext ctx, ModelNode address, String staticPart) {
        ModelNode request;
        if (ctx.getModelControllerClient() == null) {
            return Collections.emptyList();
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (ctx.isDomainMode()) {
                String host = null;
                Property prop = address.get(0).asProperty();
                if (prop.getName().equals("host")) {
                    host = prop.getValue().asString();
                } else {
                    ModelControllerClient client = ctx.getModelControllerClient();
                    ModelNode req = Util.buildRequest(ctx, new DefaultOperationRequestAddress(), "read-attribute");
                    req.get("name").set("local-host-name");
                    ModelNode outcome = client.execute(req);
                    if (!Util.isSuccess(outcome) || !outcome.has("result")) {
                        return Collections.emptyList();
                    }
                    host = outcome.get("result").asString();
                }
                builder.addNode("host", host);
            }
            builder.addNode("core-service", "capability-registry");
            builder.setOperationName("suggest-capabilities");
            builder.addProperty("name", staticPart);
            request = builder.buildRequest();
            request.get("dependent-address").set(address);
        }
        catch (IOException | CommandFormatException e) {
            log.trace(null, e);
            return Collections.emptyList();
        }
        ArrayList<String> lst = new ArrayList<String>();
        try {
            ModelNode result;
            ModelNode response = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(response) && (result = response.get("result")).isDefined()) {
                for (ModelNode mn : result.asList()) {
                    lst.add(mn.asString());
                }
            }
        }
        catch (IOException ex) {
            log.trace(null, ex);
            return Collections.emptyList();
        }
        Collections.sort(lst);
        return lst;
    }
}

