/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.aesh.terminal.utils.Config;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class BatchRunHandler
extends BaseOperationCommand {
    private final ArgumentWithValue file;
    private final ArgumentWithoutValue verbose;

    public BatchRunHandler(CommandContext ctx) {
        super(ctx, "batch-run", true);
        FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.file = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, "--file");
        this.verbose = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--verbose", "-v");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        OperationResponse response;
        boolean v = this.verbose.isPresent(ctx.getParsedCommandLine());
        boolean failed = false;
        boolean hasFile = this.file.getValue(ctx.getParsedCommandLine()) != null;
        try {
            ModelNode request = this.buildRequest(ctx);
            OperationBuilder builder = new OperationBuilder(request, true);
            for (String path : this.getAttachments(ctx).getAttachedFiles()) {
                builder.addFileAsAttachment(new File(path));
            }
            ModelControllerClient client = ctx.getModelControllerClient();
            try {
                response = client.executeOperation(builder.build(), OperationMessageHandler.DISCARD);
            }
            catch (Exception e) {
                throw new CommandFormatException("Failed to perform operation: " + e.getLocalizedMessage());
            }
            if (!Util.isSuccess(response.getResponseNode())) {
                String msg = BatchRunHandler.formatBatchError(ctx, response.getResponseNode());
                if (msg == null) {
                    msg = Util.getFailureDescription(response.getResponseNode());
                }
                throw new CommandFormatException(msg);
            }
            ModelNode steps = response.getResponseNode().get("result");
            if (steps.isDefined()) {
                Batch batch = ctx.getBatchManager().getActiveBatch();
                int i = 1;
                for (BatchedCommand cmd : batch.getCommands()) {
                    ModelNode step = steps.get("step-" + i);
                    if (!step.isDefined()) continue;
                    if (cmd.getResponseHandler() != null) {
                        cmd.getResponseHandler().handleResponse(step, response);
                    }
                    ++i;
                }
            }
        }
        catch (CommandLineException e) {
            failed = true;
            if (hasFile) {
                throw new CommandLineException("The batch failed with the following error: ", e);
            }
            throw new CommandLineException("The batch failed with the following error (you are remaining in the batch editing mode to have a chance to correct the error)", e);
        }
        finally {
            if (hasFile) {
                ctx.getBatchManager().discardActiveBatch();
            } else if (!failed && ctx.getBatchManager().isBatchActive()) {
                ctx.getBatchManager().discardActiveBatch();
            }
        }
        if (v) {
            ctx.printDMR(response.getResponseNode());
        } else {
            ctx.printLine("The batch executed successfully");
            super.handleResponse(ctx, response.getResponseNode(), true);
        }
    }

    private static String formatBatchError(CommandContext ctx, ModelNode responseNode) {
        if (responseNode == null) {
            return null;
        }
        ModelNode mn = responseNode.get("result");
        String msg = null;
        try {
            if (mn.isDefined()) {
                int index = 0;
                Batch batch = ctx.getBatchManager().getActiveBatch();
                StringBuilder b = new StringBuilder();
                ModelNode fd = responseNode.get("failure-description");
                if (fd.isDefined()) {
                    Property p = fd.asProperty();
                    b.append(Config.getLineSeparator()).append(p.getName()).append(Config.getLineSeparator());
                    boolean foundError = false;
                    for (Property prop : mn.asPropertyList()) {
                        ModelNode val = prop.getValue();
                        if (val.hasDefined("failure-description")) {
                            b.append("Step: step-").append(index + 1).append(Config.getLineSeparator());
                            b.append("Operation: ").append(batch.getCommands().get(index).getCommand()).append(Config.getLineSeparator());
                            b.append("Failure: ").append(val.get("failure-description").asString()).append(Config.getLineSeparator());
                            foundError = true;
                        }
                        ++index;
                    }
                    if (foundError) {
                        msg = b.toString();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    @Override
    protected ModelNode buildRequestWOValidation(CommandContext ctx) throws CommandFormatException {
        String path = this.file.getValue(ctx.getParsedCommandLine());
        ModelNode headersNode = this.headers.isPresent(ctx.getParsedCommandLine()) ? this.headers.toModelNode(ctx) : null;
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            if (path != null) {
                throw new CommandFormatException("--file is not allowed in the batch mode.");
            }
            Batch batch = batchManager.getActiveBatch();
            List<BatchedCommand> currentBatch = batch.getCommands();
            if (currentBatch.isEmpty()) {
                batchManager.discardActiveBatch();
                throw new CommandFormatException("The batch is empty.");
            }
            ModelNode request = batch.toRequest();
            if (headersNode != null) {
                request.get("operation-headers").set(headersNode);
            }
            return request;
        }
        if (path != null) {
            File f = new File(path);
            if (!f.exists()) {
                throw new CommandFormatException("File " + f.getAbsolutePath() + " does not exist.");
            }
            File currentDir = ctx.getCurrentDir();
            File baseDir = f.getParentFile();
            if (baseDir != null) {
                ctx.setCurrentDir(baseDir);
            }
            try {
                ModelNode modelNode;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                try {
                    String line = reader.readLine();
                    batchManager.activateNewBatch();
                    while (line != null) {
                        ctx.handle(line.trim());
                        line = reader.readLine();
                    }
                    ModelNode request = batchManager.getActiveBatch().toRequest();
                    if (headersNode != null) {
                        request.get("operation-headers").set(headersNode);
                    }
                    modelNode = request;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CommandFormatException("Failed to read file " + f.getAbsolutePath(), e);
                    }
                    catch (CommandLineException e) {
                        throw new CommandFormatException("Failed to create batch from " + f.getAbsolutePath(), e);
                    }
                }
                reader.close();
                return modelNode;
            }
            finally {
                if (baseDir != null) {
                    ctx.setCurrentDir(currentDir);
                }
            }
        }
        throw new CommandFormatException("Without arguments the command can be executed only in the batch mode.");
    }

    @Override
    public Attachments getAttachments(CommandContext ctx) {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            Batch batch = batchManager.getActiveBatch();
            return batch.getAttachments();
        }
        return new Attachments();
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandLineException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        throw new UnsupportedOperationException();
    }
}

