/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.util;

import java.security.AccessController;
import java.util.Arrays;

public final class IdentityIntSet<T>
implements Cloneable {
    private static final int DEFAULT_REINITIALIZE_CAPACITY_THRESHOLD = 65536;
    private static final int REINITIALIZE_CAPACITY_THRESHOLD = AccessController.doPrivileged(() -> Integer.getInteger("jboss.marshalling.identityint.reinitialize.capacity.threshold", 65536));
    private Object[] keys;
    private int count;
    private int resizeCount;
    private final int initialCapacity;
    private final float loadFactor;

    public IdentityIntSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be > 0");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0.0 and < 1.0");
        }
        if (initialCapacity < 16) {
            initialCapacity = 16;
        } else {
            int c = Integer.highestOneBit(initialCapacity) - 1;
            initialCapacity = Integer.highestOneBit(initialCapacity + c);
        }
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.init();
    }

    private void init() {
        this.keys = new Object[this.initialCapacity];
        this.resizeCount = (int)((double)this.initialCapacity * (double)this.loadFactor);
    }

    public IdentityIntSet<T> clone() {
        try {
            IdentityIntSet clone = (IdentityIntSet)super.clone();
            clone.keys = (Object[])this.keys.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public IdentityIntSet(float loadFactor) {
        this(64, loadFactor);
    }

    public IdentityIntSet(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public IdentityIntSet() {
        this(0.5f);
    }

    public boolean contains(T key) {
        Object[] keys = this.keys;
        int mask = keys.length - 1;
        int hc = System.identityHashCode(key) & mask;
        Object v;
        while ((v = keys[hc]) != key) {
            if (v == null) {
                return false;
            }
            hc = hc + 1 & mask;
        }
        return true;
    }

    public boolean add(T key) {
        int hc;
        Object[] keys = this.keys;
        int mask = keys.length - 1;
        int idx = hc = System.identityHashCode(key) & mask;
        while (true) {
            Object v;
            if ((v = keys[idx]) == null) {
                keys[idx] = key;
                if (++this.count > this.resizeCount) {
                    this.resize();
                }
                return true;
            }
            if (v == key) {
                return false;
            }
            idx = hc++ & mask;
        }
    }

    private void resize() {
        Object[] oldKeys = this.keys;
        int oldsize = oldKeys.length;
        if (oldsize >= 0x40000000) {
            throw new IllegalStateException("Table full");
        }
        int newsize = oldsize << 1;
        int mask = newsize - 1;
        Object[] newKeys = new Object[newsize];
        this.keys = newKeys;
        if ((this.resizeCount <<= 1) == 0) {
            this.resizeCount = Integer.MAX_VALUE;
        }
        block0: for (int oi = 0; oi < oldsize; ++oi) {
            Object key = oldKeys[oi];
            if (key == null) continue;
            int ni = System.identityHashCode(key) & mask;
            while (true) {
                Object v;
                if ((v = newKeys[ni]) == null) {
                    newKeys[ni] = key;
                    continue block0;
                }
                ni = ni + 1 & mask;
            }
        }
    }

    public void clear() {
        if (this.keys.length > REINITIALIZE_CAPACITY_THRESHOLD) {
            this.init();
        } else {
            Arrays.fill(this.keys, null);
        }
        this.count = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Set length = ").append(this.keys.length).append(", count = ").append(this.count).append(", resize count = ").append(this.resizeCount).append('\n');
        for (int i = 0; i < this.keys.length; ++i) {
            builder.append('[').append(i).append("] = ");
            if (this.keys[i] != null) {
                int hc = System.identityHashCode(this.keys[i]);
                builder.append("{ ").append(this.keys[i]).append(" (hash ").append(hc).append(", modulus ").append(hc % this.keys.length).append(") }");
            } else {
                builder.append("(blank)");
            }
            builder.append('\n');
        }
        return builder.toString();
    }
}

