/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.Iterator;
import org.wildfly.security.authz.Roles;

class AddPrefixRoles
implements Roles {
    private final Roles delegate;
    private final String prefix;

    AddPrefixRoles(Roles delegate, String prefix) {
        this.delegate = delegate;
        this.prefix = prefix;
    }

    @Override
    public boolean contains(String roleName) {
        String prefix = this.prefix;
        return roleName.startsWith(prefix) && this.delegate.contains(roleName.substring(prefix.length()));
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator iterator = this.delegate.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return AddPrefixRoles.this.prefix + (String)iterator.next();
            }
        };
    }
}

