/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;

public class JMSManagementHelper {
    private static ClientMessage getCoreMessage(Message jmsMessage) {
        if (!(jmsMessage instanceof ActiveMQMessage)) {
            throw new IllegalArgumentException("Cannot send a foreign message as a management message " + jmsMessage.getClass().getName());
        }
        return ((ActiveMQMessage)jmsMessage).getCoreMessage();
    }

    public static void putAttribute(Message message, String resourceName, String attribute) throws JMSException {
        ManagementHelper.putAttribute(JMSManagementHelper.getCoreMessage(message), resourceName, attribute);
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation(JMSManagementHelper.getCoreMessage(message), resourceName, operationName);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    private static JMSException convertFromException(Exception e) {
        JMSException jmse = new JMSException(e.getMessage());
        jmse.initCause(e);
        return jmse;
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName, Object ... parameters) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation(JMSManagementHelper.getCoreMessage(message), resourceName, operationName, parameters);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    public static boolean isOperationResult(Message message) throws JMSException {
        return ManagementHelper.isOperationResult(JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean isAttributesResult(Message message) throws JMSException {
        return ManagementHelper.isAttributesResult(JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean hasOperationSucceeded(Message message) throws JMSException {
        return ManagementHelper.hasOperationSucceeded(JMSManagementHelper.getCoreMessage(message));
    }

    public static Object[] getResults(Message message) throws Exception {
        return ManagementHelper.getResults(JMSManagementHelper.getCoreMessage(message));
    }

    public static Object getResult(Message message) throws Exception {
        return JMSManagementHelper.getResult(message, null);
    }

    public static Object getResult(Message message, Class desiredType) throws Exception {
        return ManagementHelper.getResult(JMSManagementHelper.getCoreMessage(message), desiredType);
    }

    private JMSManagementHelper() {
    }
}

