/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import org.jboss.marshalling.ChainedUnmarshallingObjectInputFilter;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.UnmarshallingObjectInputFilterImpl;

@FunctionalInterface
public interface UnmarshallingObjectInputFilter {
    public static final UnmarshallingObjectInputFilter ACCEPTING = input -> Status.ALLOWED;
    public static final UnmarshallingObjectInputFilter REJECTING = input -> Status.REJECTED;

    public Status checkInput(FilterInfo var1);

    public static enum Status {
        ALLOWED,
        REJECTED,
        UNDECIDED;

    }

    public static final class Factory {
        private Factory() {
        }

        public static UnmarshallingObjectInputFilter createFilter(String filterSpec) {
            return Factory.createFilter(filterSpec, false);
        }

        public static UnmarshallingObjectInputFilter createFilter(String filterSpec, boolean checkJEPS290ProcessFilter) {
            UnmarshallingObjectInputFilter processWide;
            UnmarshallingObjectInputFilter result = new UnmarshallingObjectInputFilterImpl(filterSpec);
            if (checkJEPS290ProcessFilter && (processWide = MarshallingConfiguration.getJEPS290ProcessWideFilter()) != null) {
                result = new ChainedUnmarshallingObjectInputFilter(processWide, result);
            }
            return result;
        }
    }

    public static interface FilterInfo {
        public Class<?> getUnmarshalledClass();

        public long getArrayLength();

        public long getDepth();

        public long getReferences();

        public long getStreamBytes();
    }
}

