/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.AbstractProducerCreditsImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;

public class ClientProducerCreditsImpl
extends AbstractProducerCreditsImpl {
    private final Semaphore semaphore = new Semaphore(0, false);

    public ClientProducerCreditsImpl(ClientSessionInternal session, SimpleString address, int windowSize) {
        super(session, address, windowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterAcquired(int credits) throws ActiveMQAddressFullException {
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            super.afterAcquired(credits);
            if (this.serverRespondedWithFail) {
                this.serverRespondedWithFail = false;
                this.semaphore.drainPermits();
                this.pendingCredits = 0;
                this.arriving = 0;
                throw ActiveMQClientMessageBundle.BUNDLE.addressIsFull(this.address.toString(), credits);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualAcquire(int credits) {
        boolean tryAcquire;
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            tryAcquire = this.semaphore.tryAcquire(credits);
        }
        if (!tryAcquire && !this.closed) {
            this.blocked = true;
            try {
                while (!this.semaphore.tryAcquire(credits, 10L, TimeUnit.SECONDS)) {
                    ActiveMQClientLogger.LOGGER.outOfCreditOnFlowControl(String.valueOf(this.address));
                }
            }
            catch (InterruptedException interrupted) {
                Thread.currentThread().interrupt();
                throw new ActiveMQInterruptedException(interrupted);
            }
            finally {
                this.blocked = false;
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.semaphore.drainPermits();
        super.reset();
    }

    @Override
    public void close() {
        super.close();
        this.semaphore.release(0x3FFFFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveCredits(int credits) {
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            super.receiveCredits(credits);
        }
        this.semaphore.release(credits);
    }

    @Override
    public int getBalance() {
        return this.semaphore.availablePermits();
    }
}

