/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.Env;

public class CheckDependencies {
    public static final boolean isEpollAvailable() {
        try {
            return Env.isLinuxOs() && Epoll.isAvailable();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ActiveMQClientLogger.LOGGER.unableToCheckEpollAvailabilitynoClass();
            return false;
        }
        catch (Throwable e) {
            ActiveMQClientLogger.LOGGER.unableToCheckEpollAvailability(e);
            return false;
        }
    }

    public static final boolean isKQueueAvailable() {
        try {
            return Env.isMacOs() && KQueue.isAvailable();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ActiveMQClientLogger.LOGGER.unableToCheckKQueueAvailabilityNoClass();
            return false;
        }
        catch (Throwable e) {
            ActiveMQClientLogger.LOGGER.unableToCheckKQueueAvailability(e);
            return false;
        }
    }
}

