/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.FailureDetection;
import org.jgroups.util.TimeService;
import org.jgroups.util.Util;

public class FD_ALL
extends FailureDetection {
    @Property(description="Interval at which the HEARTBEAT timeouts are checked", type=AttributeType.TIME)
    protected long timeout_check_interval = 2000L;
    @Property(description="Uses TimeService to get the current time rather than calling System.nanoTime().")
    protected boolean use_time_service = true;
    protected final ConcurrentMap<Address, Long> timestamps = Util.createConcurrentMap();
    protected TimeService time_service;

    @Override
    protected Map<Address, ?> getTimestamps() {
        return this.timestamps;
    }

    @Override
    public long getTimeoutCheckInterval() {
        return this.timeout_check_interval;
    }

    public <T extends FailureDetection> T setTimeoutCheckInterval(long i) {
        this.timeout_check_interval = i;
        return (T)this;
    }

    @ManagedOperation(description="Prints timestamps")
    public String printTimestamps() {
        return this._printTimestamps();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.time_service = this.getTransport().getTimeService();
        if (this.time_service == null) {
            this.log.warn("%s: time service is not available, using System.nanoTime() instead", this.local_addr);
        } else if (this.time_service.interval() > this.timeout) {
            this.log.warn("%s: interval of time service (%d) is greater than timeout (%d), disabling time service", this.local_addr, this.time_service.interval(), this.timeout);
            this.use_time_service = false;
        }
        if (this.interval > this.timeout) {
            this.log.warn("interval (%d) is bigger than timeout (%d); this will lead to false suspicions", this.interval, this.timeout);
        }
    }

    @Override
    protected void update(Address sender, boolean log_msg, boolean skip_if_exists) {
        if (sender != null && !sender.equals(this.local_addr)) {
            if (skip_if_exists) {
                this.timestamps.putIfAbsent(sender, this.getTimestamp());
            } else {
                this.timestamps.put(sender, this.getTimestamp());
            }
        }
        if (log_msg && this.log.isTraceEnabled()) {
            this.log.trace("%s: received heartbeat from %s", this.local_addr, sender);
        }
    }

    protected long getTimestamp() {
        return this.use_time_service && this.time_service != null ? this.time_service.timestamp() : System.nanoTime();
    }

    @Override
    protected <T> boolean needsToBeSuspected(Address mbr, T value) {
        long val = (Long)value;
        long diff = TimeUnit.MILLISECONDS.convert(this.getTimestamp() - val, TimeUnit.NANOSECONDS);
        if (diff > this.timeout) {
            this.log.debug("%s: haven't received a heartbeat from %s for %s ms, adding it to suspect list", this.local_addr, mbr, diff);
            return true;
        }
        return false;
    }

    @Override
    protected String getTimeoutCheckerInfo() {
        return FD_ALL.class.getSimpleName() + ": " + this.getClass().getSimpleName() + " (interval=" + this.timeout_check_interval + " ms)";
    }

    protected String _printTimestamps() {
        StringBuilder sb = new StringBuilder();
        long current_time = this.getTimestamp();
        for (Map.Entry entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            sb.append(TimeUnit.SECONDS.convert(current_time - (Long)entry.getValue(), TimeUnit.NANOSECONDS)).append(" secs old\n");
        }
        return sb.toString();
    }
}

