/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.util.CreditMap;
import org.jgroups.util.SizeBoundedQueue;
import org.jgroups.util.Util;

public class NonBlockingCreditMap
extends CreditMap {
    protected final SizeBoundedQueue<Message> msg_queue;
    protected boolean queuing;
    protected final Consumer<Message> send_function;
    protected static final Consumer<Message> NO_OP_SEND_FUNCTION = msg -> {};
    protected final LongAdder num_queued = new LongAdder();

    public NonBlockingCreditMap(long max_credits, int max_size, Lock lock) {
        this(max_credits, max_size, lock, NO_OP_SEND_FUNCTION);
    }

    public NonBlockingCreditMap(long max_credits, int max_size, Lock lock, Consumer<Message> send_function) {
        super(max_credits, lock);
        this.msg_queue = new SizeBoundedQueue(max_size, lock);
        this.send_function = send_function;
    }

    public boolean isQueuing() {
        return this.queuing;
    }

    public int getQueuedMessages() {
        return this.msg_queue.getElements();
    }

    public int getQueuedMessageSize() {
        return this.msg_queue.size();
    }

    public int getEnqueuedMessages() {
        return this.num_queued.intValue();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_queued.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decrement(Message msg, int credits, long timeout) {
        this.lock.lock();
        try {
            if (this.done) {
                boolean bl = false;
                return bl;
            }
            if (this.queuing) {
                boolean bl = this.addToQueue(msg, credits);
                return bl;
            }
            if (this.decrement(credits)) {
                boolean bl = true;
                return bl;
            }
            this.queuing = true;
            boolean bl = this.addToQueue(msg, credits);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replenish(Address sender, long new_credits) {
        ArrayList drain_list;
        if (sender == null) {
            return;
        }
        this.lock.lock();
        try {
            super.replenish(sender, new_credits);
            if (!this.queuing || this.msg_queue.isEmpty()) {
                return;
            }
            drain_list = new ArrayList(this.msg_queue.getElements());
            int drained = this.msg_queue.drainTo(drain_list, (int)this.min_credits);
            if (drained > 0) {
                this.decrement(drained);
            }
            if (this.msg_queue.isEmpty()) {
                this.queuing = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!drain_list.isEmpty()) {
            drain_list.forEach(this.send_function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long remove(Address key) {
        this.lock.lock();
        try {
            Long retval = super.remove(key);
            this.msg_queue.clear(false);
            Long l = retval;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
            this.queuing = false;
            this.msg_queue.clear(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CreditMap reset() {
        this.lock.lock();
        try {
            super.reset();
            this.queuing = false;
            this.msg_queue.clear(true);
            NonBlockingCreditMap nonBlockingCreditMap = this;
            return nonBlockingCreditMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        return String.format("%s bytes left (queuing: %b, msg-queue size: %d, bytes: %s, enqueued: %d)", super.toString(), this.isQueuing(), this.getQueuedMessages(), Util.printBytes(this.getQueuedMessageSize()), this.num_queued.intValue());
    }

    protected boolean addToQueue(Message msg, int length) {
        try {
            this.msg_queue.add(msg, length);
            this.num_queued.increment();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }
}

