/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return GetTCCLAction.INSTANCE.run();
        }
        return AccessController.doPrivileged(GetTCCLAction.INSTANCE);
    }

    static ClassLoader setContextClassLoader(ClassLoader newClassLoader) {
        if (System.getSecurityManager() == null) {
            return new SetTCCLAction(newClassLoader).run();
        }
        return AccessController.doPrivileged(new SetTCCLAction(newClassLoader));
    }

    private static final class SetTCCLAction
    implements PrivilegedAction<ClassLoader> {
        private final ClassLoader newClassLoader;

        private SetTCCLAction(ClassLoader newClassLoader) {
            this.newClassLoader = newClassLoader;
        }

        @Override
        public ClassLoader run() {
            ClassLoader oldClassLoader = GetTCCLAction.INSTANCE.run();
            Thread.currentThread().setContextClassLoader(this.newClassLoader);
            return oldClassLoader;
        }
    }

    private static final class GetTCCLAction
    implements PrivilegedAction<ClassLoader> {
        private static final GetTCCLAction INSTANCE = new GetTCCLAction();

        private GetTCCLAction() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

