/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.math.BigInteger;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;

public final class RSAParameterSpec
implements AlgorithmParameterSpec {
    private final BigInteger modulus;

    public RSAParameterSpec(BigInteger modulus) {
        Assert.checkNotNullParam("modulus", modulus);
        this.modulus = modulus;
    }

    public RSAParameterSpec(RSAKey rsaKey) {
        this(Assert.checkNotNullParam("rsaKey", rsaKey).getModulus());
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RSAParameterSpec && this.modulus.equals(((RSAParameterSpec)obj).getModulus());
    }

    public int hashCode() {
        return this.modulus.hashCode();
    }
}

