/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.context;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.wildfly.common.Assert;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.context.ContextPermission;

final class ContextPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -3651721703337368351L;
    private volatile State state = emptyState;
    private static final AtomicReferenceFieldUpdater<ContextPermissionCollection, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ContextPermissionCollection.class, State.class, "state");
    private static final State emptyState = new State(null, Collections.emptyMap());

    ContextPermissionCollection() {
    }

    @Override
    public void add(Permission permission) throws SecurityException, IllegalArgumentException {
        Assert.checkNotNullParam("permission", permission);
        if (!(permission instanceof ContextPermission)) {
            throw CommonMessages.msg.invalidPermissionType(ContextPermission.class, permission.getClass());
        }
        this.add((ContextPermission)permission);
    }

    public void add(ContextPermission contextPermission) throws SecurityException {
        Map<String, ContextPermission> newPermissions;
        ContextPermission newGlobalPermission;
        State newState;
        State oldState;
        Assert.checkNotNullParam("contextPermission", contextPermission);
        if (this.isReadOnly()) {
            throw CommonMessages.msg.readOnlyPermissionCollection();
        }
        int actionBits = contextPermission.getActionBits();
        if (actionBits == 0) {
            return;
        }
        String name = contextPermission.getName();
        do {
            int globalActions;
            oldState = this.state;
            ContextPermission oldGlobalPermission = oldState.globalPermission;
            int n = globalActions = oldGlobalPermission == null ? 0 : oldGlobalPermission.getActionBits();
            if (oldGlobalPermission != null && oldGlobalPermission.implies(contextPermission)) {
                return;
            }
            Map<String, ContextPermission> oldPermissions = oldState.permissions;
            if (name.equals("*")) {
                newGlobalPermission = oldGlobalPermission == null ? contextPermission : oldGlobalPermission.withActionBits(contextPermission.getActionBits());
                newPermissions = ContextPermissionCollection.cloneWithout(oldPermissions, newGlobalPermission);
                continue;
            }
            newGlobalPermission = oldGlobalPermission;
            ContextPermission mapPermission = oldPermissions.get(name);
            if (mapPermission == null) {
                if (oldPermissions.isEmpty()) {
                    newPermissions = Collections.singletonMap(name, contextPermission.withoutActionBits(globalActions));
                    continue;
                }
                newPermissions = new HashMap<String, ContextPermission>(oldPermissions);
                newPermissions.put(name, contextPermission.withoutActionBits(globalActions));
                continue;
            }
            if (((mapPermission.getActionBits() | globalActions) & actionBits) == actionBits) {
                return;
            }
            if (oldPermissions.size() == 1) {
                newPermissions = Collections.singletonMap(name, mapPermission.withActionBits(actionBits & ~globalActions));
                continue;
            }
            newPermissions = new HashMap<String, ContextPermission>(oldPermissions);
            newPermissions.put(name, mapPermission.withActionBits(actionBits & ~globalActions));
        } while (!stateUpdater.compareAndSet(this, oldState, newState = new State(newGlobalPermission, newPermissions)));
    }

    private static Map<String, ContextPermission> cloneWithout(Map<String, ContextPermission> oldPermissions, ContextPermission newGlobalPermission) {
        ContextPermission second;
        ContextPermission first;
        Iterator<ContextPermission> iterator = oldPermissions.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Collections.emptyMap();
        } while (newGlobalPermission.implies(first = iterator.next()));
        int globalActionBits = newGlobalPermission.getActionBits();
        do {
            if (iterator.hasNext()) continue;
            return Collections.singletonMap(first.getName(), first.withoutActionBits(globalActionBits));
        } while (newGlobalPermission.implies(second = iterator.next()));
        HashMap<String, ContextPermission> newMap = new HashMap<String, ContextPermission>();
        newMap.put(first.getName(), first.withoutActionBits(globalActionBits));
        newMap.put(second.getName(), second.withoutActionBits(globalActionBits));
        while (iterator.hasNext()) {
            ContextPermission subsequent = iterator.next();
            if (newGlobalPermission.implies(subsequent)) continue;
            newMap.put(subsequent.getName(), subsequent.withoutActionBits(globalActionBits));
        }
        return newMap;
    }

    @Override
    public boolean implies(Permission permission) {
        return permission instanceof ContextPermission && this.implies((ContextPermission)permission);
    }

    public boolean implies(ContextPermission permission) {
        int globalBits;
        if (permission == null) {
            return false;
        }
        State state = this.state;
        ContextPermission globalPermission = state.globalPermission;
        if (globalPermission != null) {
            if (globalPermission.implies(permission)) {
                return true;
            }
            globalBits = globalPermission.getActionBits();
        } else {
            globalBits = 0;
        }
        int bits = permission.getActionBits();
        String name = permission.getName();
        if (name.equals("*")) {
            return false;
        }
        ContextPermission ourPermission = state.permissions.get(name);
        if (ourPermission == null) {
            return false;
        }
        int ourBits = ourPermission.getActionBits() | globalBits;
        return (bits & ourBits) == bits;
    }

    @Override
    public Enumeration<Permission> elements() {
        final State state = this.state;
        final Iterator<ContextPermission> iterator = state.permissions.values().iterator();
        return new Enumeration<Permission>(){
            Permission next;
            {
                this.next = state.globalPermission;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.next != null) {
                    return true;
                }
                if (iterator.hasNext()) {
                    this.next = (Permission)iterator.next();
                    return true;
                }
                return false;
            }

            @Override
            public Permission nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                try {
                    Permission permission = this.next;
                    return permission;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }

    static class State {
        private final ContextPermission globalPermission;
        private final Map<String, ContextPermission> permissions;

        State(ContextPermission globalPermission, Map<String, ContextPermission> permissions) {
            this.globalPermission = globalPermission;
            this.permissions = permissions;
        }
    }
}

