/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.marshalling._private.GetUnsafeAction;
import org.jboss.marshalling.reflect.JDKSpecific;
import org.jboss.marshalling.reflect.SerMethods;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import sun.misc.Unsafe;

public final class SerializableClass {
    private static final Unsafe unsafe = System.getSecurityManager() == null ? GetUnsafeAction.INSTANCE.run() : AccessController.doPrivileged(GetUnsafeAction.INSTANCE);
    private static final SerializableClassRegistry REGISTRY = SerializableClassRegistry.getInstanceUnchecked();
    private final IdentityHashMap<Class<?>, Constructor<?>> nonInitConstructors;
    private final Class<?> subject;
    private final SerMethods serMethods;
    private final SerializableField[] fields;
    private final Map<String, SerializableField> fieldsByName;
    private final long effectiveSerialVersionUID;
    private final boolean isRecord;
    private static final Comparator<? super SerializableField> NAME_COMPARATOR = new Comparator<SerializableField>(){

        @Override
        public int compare(SerializableField o1, SerializableField o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final SerializableField[] NOFIELDS = new SerializableField[0];
    private static final IdentityHashMap<Class<?>, Constructor<?>> EMPTY_IHM = new IdentityHashMap(0);

    SerializableClass(Class<?> subject) {
        this.subject = subject;
        this.isRecord = JDKSpecific.isRecord(subject);
        if (this.isRecord) {
            this.nonInitConstructors = EMPTY_IHM;
        } else {
            IdentityHashMap constructorMap = new IdentityHashMap();
            for (Class<?> t = subject.getSuperclass(); t != null; t = t.getSuperclass()) {
                SerializableClass lookedUp = REGISTRY.lookup(t);
                Constructor<?> constructor = lookedUp.serMethods.getNoArgConstructor();
                if (constructor == null) continue;
                constructorMap.put(t, SerMethods.newConstructorForSerialization(subject, constructor));
            }
            this.nonInitConstructors = constructorMap;
        }
        this.serMethods = new SerMethods(subject);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(subject);
        long l = this.effectiveSerialVersionUID = objectStreamClass == null ? 0L : objectStreamClass.getSerialVersionUID();
        if (subject.getName().indexOf(47) != -1) {
            this.fields = NOFIELDS;
            this.fieldsByName = Collections.emptyMap();
        } else {
            HashMap<String, SerializableField> fieldsByName = new HashMap<String, SerializableField>();
            this.fields = SerializableClass.getSerializableFields(subject, this.isRecord);
            for (SerializableField serializableField : this.fields) {
                fieldsByName.put(serializableField.getName(), serializableField);
            }
            this.fieldsByName = fieldsByName;
        }
    }

    private static SerializableField[] getSerializableFields(Class<?> clazz, boolean isRecord) {
        Field[] declaredFields = clazz.getDeclaredFields();
        if (isRecord) {
            HashMap<String, Field> map = new HashMap<String, Field>();
            for (Field field : declaredFields) {
                map.put(field.getName(), field);
            }
            SerializableField.RecordComponent[] recordComponents = JDKSpecific.getRecordComponents(clazz);
            SerializableField[] fields = new SerializableField[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                Field field;
                field = (Field)map.get(recordComponents[i].getName());
                fields[i] = new SerializableField(field.getType(), field.getName(), false, field, recordComponents[i]);
            }
            Arrays.sort(fields, NAME_COMPARATOR);
            return fields;
        }
        ObjectStreamField[] objectStreamFields = SerializableClass.getDeclaredSerialPersistentFields(clazz);
        if (objectStreamFields != null) {
            HashMap<String, Field> map = new HashMap<String, Field>();
            for (Field field : declaredFields) {
                map.put(field.getName(), field);
            }
            Object[] fields = new SerializableField[objectStreamFields.length];
            for (int i = 0; i < objectStreamFields.length; ++i) {
                ObjectStreamField field = objectStreamFields[i];
                String name = field.getName();
                Field realField = (Field)map.get(name);
                fields[i] = realField != null && realField.getType() == field.getType() ? new SerializableField(field.getType(), name, field.isUnshared(), realField, null) : new SerializableField(field.getType(), name, field.isUnshared(), null, null);
            }
            Arrays.sort(fields, NAME_COMPARATOR);
            return fields;
        }
        ArrayList<SerializableField> fields = new ArrayList<SerializableField>(declaredFields.length);
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            fields.add(new SerializableField(field.getType(), field.getName(), false, field, null));
        }
        Collections.sort(fields, NAME_COMPARATOR);
        return fields.toArray(new SerializableField[0]);
    }

    private static ObjectStreamField[] getDeclaredSerialPersistentFields(Class<?> clazz) {
        Field field;
        try {
            field = clazz.getDeclaredField("serialPersistentFields");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (field == null) {
            return null;
        }
        int requiredModifiers = 26;
        if ((field.getModifiers() & 0x1A) != 26) {
            return null;
        }
        try {
            return (ObjectStreamField[])unsafe.getObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public SerializableField[] getFields() {
        return this.fields;
    }

    public SerializableField getSerializableField(String name, Class<?> fieldType, boolean unshared) throws ClassNotFoundException {
        SerializableField serializableField = this.fieldsByName.get(name);
        if (serializableField != null) {
            return serializableField;
        }
        return new SerializableField(fieldType, name, unshared, null, null);
    }

    public SerializableField getSerializableFieldByName(String name) throws ClassNotFoundException {
        return this.fieldsByName.get(name);
    }

    public boolean hasWriteObject() {
        return this.serMethods.hasWriteObject();
    }

    public void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
        this.serMethods.callWriteObject(object, outputStream);
    }

    public boolean hasReadObject() {
        return this.serMethods.hasReadObject();
    }

    public void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        this.serMethods.callReadObject(object, inputStream);
    }

    public boolean hasReadObjectNoData() {
        return this.serMethods.hasReadObjectNoData();
    }

    public void callReadObjectNoData(Object object) throws ObjectStreamException {
        this.serMethods.callReadObjectNoData(object);
    }

    public boolean hasWriteReplace() {
        return this.serMethods.hasWriteReplace();
    }

    public Object callWriteReplace(Object object) throws ObjectStreamException {
        return this.serMethods.callWriteReplace(object);
    }

    public boolean hasReadResolve() {
        return this.serMethods.hasReadResolve();
    }

    public Object callReadResolve(Object object) throws ObjectStreamException {
        return this.serMethods.callReadResolve(object);
    }

    public boolean hasPublicNoArgConstructor() {
        Constructor<?> noArgConstructor = this.serMethods.getNoArgConstructor();
        return noArgConstructor != null && Modifier.isPublic(noArgConstructor.getModifiers());
    }

    public Object callNoArgConstructor() throws IOException {
        Constructor<?> noArgConstructor = this.serMethods.getNoArgConstructor();
        return SerializableClass.invokeConstructor(noArgConstructor, new Object[0]);
    }

    public boolean hasObjectInputConstructor() {
        Constructor<?> objectInputConstructor = this.serMethods.getObjectInputConstructor();
        return objectInputConstructor != null && Modifier.isPublic(objectInputConstructor.getModifiers());
    }

    public Object callObjectInputConstructor(ObjectInput objectInput) throws IOException {
        Constructor<?> objectInputConstructor = this.serMethods.getObjectInputConstructor();
        return SerializableClass.invokeConstructor(objectInputConstructor, objectInput);
    }

    public boolean hasNoInitConstructor(Class<?> target) {
        return this.nonInitConstructors.containsKey(target);
    }

    public Object callNonInitConstructor(Class<?> target) {
        return SerializableClass.invokeConstructorNoException(this.nonInitConstructors.get(target), new Object[0]);
    }

    private static <T> T invokeConstructor(Constructor<T> constructor, Object ... args) throws IOException {
        if (constructor == null) {
            throw new IllegalArgumentException("No matching constructor");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    private static <T> T invokeConstructorNoException(Constructor<T> constructor, Object ... args) {
        if (constructor == null) {
            throw new IllegalArgumentException("No matching constructor");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    public long getEffectiveSerialVersionUID() {
        return this.effectiveSerialVersionUID;
    }

    public Class<?> getSubjectClass() {
        return this.subject;
    }

    <T> Constructor<T> getNoArgConstructor() {
        return this.serMethods.getNoArgConstructor();
    }

    public String toString() {
        return String.format("Serializable %s", this.getSubjectClass());
    }

    <T> Constructor<T> getNoInitConstructor() {
        Class<?> clazz = this.getClass();
        while (Serializable.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
        }
        return this.nonInitConstructors.get(clazz);
    }

    SerMethods getSerMethods() {
        return this.serMethods;
    }

    public boolean isRecord() {
        return this.isRecord;
    }

    public Object invokeRecordCanonicalConstructor(Object[] args) {
        return JDKSpecific.invokeRecordCanonicalConstructor(this.subject, this.fields, args);
    }
}

