/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.jboss.remoting3.ConnectionBuilder;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.common.Assert;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;

final class RemotingXmlParser {
    private static final String NS_REMOTING_5_0 = "urn:jboss-remoting:5.0";
    private static final String NS_REMOTING_5_1 = "urn:jboss-remoting:5.1";
    private static final String NS_REMOTING_5_2 = "urn:jboss-remoting:5.2";
    private static final Set<String> validNamespaces = new HashSet<String>(Arrays.asList("urn:jboss-remoting:5.0", "urn:jboss-remoting:5.1", "urn:jboss-remoting:5.2"));

    private RemotingXmlParser() {
    }

    static Endpoint parseEndpoint() throws ConfigXMLParseException, IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        EndpointBuilder builder = new EndpointBuilder();
        builder.setXnioWorker((XnioWorker)XnioWorker.getContextManager().get());
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(validNamespaces);){
                RemotingXmlParser.parseDocument(streamReader, builder);
                Endpoint endpoint = builder.build();
                return endpoint;
            }
        }
        return null;
    }

    private static void parseDocument(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    RemotingXmlParser.checkElementNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "endpoint": {
                            RemotingXmlParser.parseEndpointElement(reader, builder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                default: {
                    throw reader.unexpectedContent();
                }
            }
        }
    }

    private static void parseEndpointElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        if (reader.hasNamespace()) {
            switch (reader.getNamespaceURI()) {
                case "urn:jboss-remoting:5.0": {
                    RemotingXmlParser.parseEndpointElement50(reader, builder, optionMapBuilder);
                    break;
                }
                case "urn:jboss-remoting:5.1": 
                case "urn:jboss-remoting:5.2": {
                    RemotingXmlParser.parseEndpointElement51(reader, builder, optionMapBuilder);
                    break;
                }
                default: {
                    throw reader.unexpectedElement();
                }
            }
            while (reader.hasNext()) {
                block9 : switch (reader.nextTag()) {
                    case 1: {
                        RemotingXmlParser.checkElementNamespace(reader);
                        switch (reader.getLocalName()) {
                            case "providers": {
                                RemotingXmlParser.parseProvidersElement(reader, builder);
                                break block9;
                            }
                            case "connections": {
                                RemotingXmlParser.parseConnectionsElement(reader, builder);
                                break block9;
                            }
                            case "options": {
                                if (reader.getNamespaceURI().equals(NS_REMOTING_5_2)) {
                                    RemotingXmlParser.parseEndpointOptions(reader, optionMapBuilder);
                                    break block9;
                                }
                                throw reader.unexpectedElement();
                            }
                        }
                        throw reader.unexpectedElement();
                    }
                    case 2: {
                        builder.setDefaultConnectionsOptionMap(optionMapBuilder.getMap());
                        return;
                    }
                }
            }
            throw reader.unexpectedDocumentEnd();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseEndpointElement51(ConfigurationXMLStreamReader reader, EndpointBuilder builder, OptionMap.Builder optionMapBuilder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        int readTimeout = -1;
        int writeTimeout = -1;
        boolean tcpKeepAlive = false;
        boolean setTcpKeepAlive = false;
        int heartbeatInterval = -1;
        block14: for (int i = 0; i < attributeCount; ++i) {
            RemotingXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    builder.setEndpointName(reader.getAttributeValueResolved(i));
                    continue block14;
                }
                case "read-timeout": {
                    readTimeout = reader.getIntAttributeValueResolved(i, 0, Integer.MAX_VALUE);
                    continue block14;
                }
                case "write-timeout": {
                    writeTimeout = reader.getIntAttributeValueResolved(i, 0, Integer.MAX_VALUE);
                    continue block14;
                }
                case "tcp-keepalive": {
                    setTcpKeepAlive = true;
                    tcpKeepAlive = reader.getBooleanAttributeValueResolved(i);
                    continue block14;
                }
                case "heartbeat-interval": {
                    heartbeatInterval = reader.getIntAttributeValueResolved(i, 0, Integer.MAX_VALUE);
                    continue block14;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if ((long)readTimeout != -1L) {
            optionMapBuilder.set(Options.READ_TIMEOUT, readTimeout);
        }
        if ((long)writeTimeout != -1L) {
            optionMapBuilder.set(Options.WRITE_TIMEOUT, writeTimeout);
        }
        if (setTcpKeepAlive) {
            optionMapBuilder.set(Options.KEEP_ALIVE, tcpKeepAlive);
        }
        if (heartbeatInterval != -1) {
            optionMapBuilder.set(RemotingOptions.HEARTBEAT_INTERVAL, heartbeatInterval);
        }
    }

    protected static void parseEndpointOptions(ConfigurationXMLStreamReader reader, OptionMap.Builder optionMapBuilder) throws ConfigXMLParseException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "option": {
                    RemotingXmlParser.parseEndpointOption(reader, optionMapBuilder);
                    continue block6;
                }
            }
            throw reader.unexpectedElement();
        }
    }

    protected static void parseEndpointOption(ConfigurationXMLStreamReader reader, OptionMap.Builder optionMapBuilder) throws ConfigXMLParseException {
        int count = reader.getAttributeCount();
        String optionName = null;
        String optionType = null;
        String optionValue = null;
        block13: for (int i = 0; i < count; ++i) {
            String attribute = reader.getAttributeLocalName(i);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case "name": {
                    optionName = attributeValue;
                    continue block13;
                }
                case "type": {
                    optionType = attributeValue;
                    if (optionType.equals("remoting") || optionType.equals("xnio")) continue block13;
                    throw reader.unexpectedAttribute(i);
                }
                case "value": {
                    optionValue = attributeValue;
                    continue block13;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        ClassLoader loader = RemotingXmlParser.class.getClassLoader();
        String optionClassName = RemotingXmlParser.getClassNameForChannelOptionType(optionType);
        String fullyQualifiedOptionName = optionClassName + "." + optionName;
        Option<?> option = Option.fromString(fullyQualifiedOptionName, loader);
        optionMapBuilder.set(option, option.parseValue(optionValue, loader));
        switch (reader.nextTag()) {
            case 2: {
                return;
            }
        }
        throw reader.unexpectedElement();
    }

    private static String getClassNameForChannelOptionType(String optionType) {
        if ("remoting".equals(optionType)) {
            return RemotingOptions.class.getName();
        }
        if ("xnio".equals(optionType)) {
            return Options.class.getName();
        }
        throw Assert.unreachableCode();
    }

    private static void parseEndpointElement50(ConfigurationXMLStreamReader reader, EndpointBuilder builder, OptionMap.Builder optionMapBuilder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        block6: for (int i = 0; i < attributeCount; ++i) {
            RemotingXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    builder.setEndpointName(reader.getAttributeValueResolved(i));
                    continue block6;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
    }

    private static void parseProvidersElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        RemotingXmlParser.expectNoAttributes(reader);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    RemotingXmlParser.checkElementNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "provider": {
                            RemotingXmlParser.parseProviderElement(reader, builder);
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void expectNoAttributes(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
    }

    private static void parseProviderElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String scheme = null;
        String[] aliases = null;
        String module = null;
        String clazz = null;
        block15: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "scheme": {
                    scheme = reader.getAttributeValueResolved(i);
                    continue block15;
                }
                case "aliases": {
                    aliases = reader.getListAttributeValueAsArrayResolved(i);
                    continue block15;
                }
                case "module": {
                    module = reader.getAttributeValueResolved(i);
                    continue block15;
                }
                case "class": {
                    clazz = reader.getAttributeValueResolved(i);
                    continue block15;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        ConnectionProviderFactoryBuilder providerBuilder = builder.addProvider(scheme);
        if (aliases != null) {
            for (void var11_13 : aliases) {
                providerBuilder.addAlias((String)var11_13);
            }
        }
        if (module == null && clazz == null) {
            throw new ConfigXMLParseException("At least one of the 'module' or 'class' attributes must be given", (XMLStreamReader)reader);
        }
        if (module != null) {
            providerBuilder.setModuleName(module);
        }
        if (clazz != null) {
            providerBuilder.setClassName(clazz);
        }
        switch (reader.nextTag()) {
            case 2: {
                return;
            }
        }
        throw reader.unexpectedElement();
    }

    private static void parseConnectionsElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        RemotingXmlParser.expectNoAttributes(reader);
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    RemotingXmlParser.checkElementNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "connection": {
                            RemotingXmlParser.parseConnectionElement(reader, builder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseConnectionElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String destination = null;
        int readTimeout = -1;
        int writeTimeout = -1;
        int ipTrafficClass = -1;
        boolean setTcpKeepAlive = false;
        boolean tcpKeepAlive = false;
        int heartbeatInterval = -1;
        block16: for (int i = 0; i < attributeCount; ++i) {
            RemotingXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "destination": {
                    destination = reader.getAttributeValueResolved(i);
                    continue block16;
                }
                case "read-timeout": {
                    readTimeout = reader.getIntAttributeValueResolved(i, 0, Integer.MAX_VALUE);
                    continue block16;
                }
                case "write-timeout": {
                    writeTimeout = reader.getIntAttributeValueResolved(i, 0, Integer.MAX_VALUE);
                    continue block16;
                }
                case "ip-traffic-class": {
                    ipTrafficClass = reader.getIntAttributeValueResolved(i, 0, 255);
                    continue block16;
                }
                case "tcp-keepalive": {
                    setTcpKeepAlive = true;
                    tcpKeepAlive = reader.getBooleanAttributeValueResolved(i);
                    continue block16;
                }
                case "heartbeat-interval": {
                    heartbeatInterval = reader.getIntAttributeValueResolved(i, 0, Integer.MAX_VALUE);
                    continue block16;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (destination == null) {
            throw reader.missingRequiredAttribute("", "destination");
        }
        ConnectionBuilder connectionBuilder = builder.addConnection(URI.create(destination));
        if ((long)readTimeout != -1L) {
            connectionBuilder.setReadTimeout(readTimeout);
        }
        if ((long)writeTimeout != -1L) {
            connectionBuilder.setWriteTimeout(writeTimeout);
        }
        if (ipTrafficClass != -1) {
            connectionBuilder.setIpTrafficClass(ipTrafficClass);
        }
        if (setTcpKeepAlive) {
            connectionBuilder.setTcpKeepAlive(tcpKeepAlive);
        }
        if (heartbeatInterval != -1) {
            connectionBuilder.setHeartbeatInterval(heartbeatInterval);
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedContent();
        }
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader, int idx) throws ConfigXMLParseException {
        String attributeNamespace = reader.getAttributeNamespace(idx);
        if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
            throw reader.unexpectedAttribute(idx);
        }
    }

    private static void checkElementNamespace(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        switch (reader.getNamespaceURI()) {
            case "urn:jboss-remoting:5.0": 
            case "urn:jboss-remoting:5.1": 
            case "urn:jboss-remoting:5.2": {
                break;
            }
            default: {
                throw reader.unexpectedElement();
            }
        }
    }
}

