/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Reverts messages based on a filter and delivers them when told")
public class REVERSE2
extends Protocol {
    protected volatile Predicate<Message> filter;
    protected final Deque<Message> queue = new ConcurrentLinkedDeque<Message>();

    public Predicate<Message> filter() {
        return this.filter;
    }

    public REVERSE2 filter(Predicate<Message> f) {
        this.filter = f;
        return this;
    }

    public int size() {
        return this.queue.size();
    }

    public int deliver() {
        Message msg;
        int count = 0;
        while ((msg = this.queue.pollLast()) != null) {
            this.up_prot.up(msg);
            ++count;
        }
        return count;
    }

    @Override
    public Object up(Message msg) {
        if (this.filter != null && this.filter.test(msg)) {
            this.queue.add(msg);
            return null;
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.filter == null) {
            this.up_prot.up(batch);
            return;
        }
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (!this.filter.test(msg)) continue;
            it.remove();
            this.queue.add(msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public String toString() {
        return String.format("%d msgs", this.queue.size());
    }
}

