/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathResource;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;

class PathResourceLoader
extends AbstractResourceLoader
implements IterableResourceLoader {
    private final String rootName;
    protected final Path root;
    protected final AccessControlContext context;
    private volatile SoftReference<Manifest> manifestRef;
    private final CodeSource codeSource;

    PathResourceLoader(String rootName, Path root, AccessControlContext context) {
        if (rootName == null) {
            throw new IllegalArgumentException("rootName is null");
        }
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.rootName = rootName;
        this.root = root;
        this.context = context;
        try {
            this.codeSource = PathResourceLoader.doPrivilegedIfNeeded(context, MalformedURLException.class, () -> new CodeSource(root.toUri().toURL(), (CodeSigner[])null));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid root file specified", e);
        }
    }

    private Manifest manifest() {
        Manifest manifest;
        SoftReference<Manifest> ref = this.manifestRef;
        if (ref != null && (manifest = ref.get()) != null) {
            return manifest;
        }
        Path manifestFile = this.root.resolve("META-INF").resolve("MANIFEST.MF");
        try {
            return PathResourceLoader.doPrivilegedIfNeeded(this.context, IOException.class, () -> {
                if (Files.isDirectory(manifestFile, new LinkOption[0])) {
                    return null;
                }
                try (InputStream is = Files.newInputStream(manifestFile, new OpenOption[0]);){
                    Manifest manifest = new Manifest(is);
                    this.manifestRef = new SoftReference<Manifest>(manifest);
                    Manifest manifest2 = manifest;
                    return manifest2;
                }
            });
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public String getLibrary(String name) {
        if (this.root.getFileSystem() == FileSystems.getDefault()) {
            String mappedName = System.mapLibraryName(name);
            for (String path : NativeLibraryResourceLoader.Identification.NATIVE_SEARCH_PATHS) {
                Path testFile;
                try {
                    testFile = this.root.resolve(path).resolve(mappedName);
                }
                catch (InvalidPathException ignored) {
                    return null;
                }
                if (!Files.exists(testFile, new LinkOption[0])) continue;
                return testFile.toAbsolutePath().toString();
            }
        }
        return null;
    }

    @Override
    public ClassSpec getClassSpec(String fileName) throws IOException {
        Path file;
        try {
            file = this.root.resolve(fileName);
        }
        catch (InvalidPathException ignored) {
            return null;
        }
        return PathResourceLoader.doPrivilegedIfNeeded(this.context, IOException.class, () -> {
            if (!Files.exists(file, new LinkOption[0])) {
                return null;
            }
            ClassSpec spec = new ClassSpec();
            spec.setCodeSource(this.codeSource);
            spec.setBytes(Files.readAllBytes(file));
            return spec;
        });
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        URL rootUrl = PathResourceLoader.doPrivilegedIfNeeded(this.context, IOException.class, () -> this.root.toUri().toURL());
        return PathResourceLoader.getPackageSpec(name, this.manifest(), rootUrl);
    }

    @Override
    public Resource getResource(String name) {
        Path file;
        String cleanName = PathUtils.canonicalize(PathUtils.relativize(name));
        try {
            file = this.root.resolve(cleanName);
        }
        catch (InvalidPathException ignored) {
            return null;
        }
        if (!PathResourceLoader.doPrivilegedIfNeeded(this.context, () -> Files.exists(file, new LinkOption[0])).booleanValue()) {
            return null;
        }
        return new PathResource(file, cleanName, this.context);
    }

    @Override
    public Iterator<Resource> iterateResources(String startPath, boolean recursive) {
        try {
            Path path;
            try {
                path = this.root.resolve(PathUtils.canonicalize(PathUtils.relativize(startPath)));
            }
            catch (InvalidPathException ignored) {
                return Collections.emptyIterator();
            }
            return Files.walk(path, recursive ? Integer.MAX_VALUE : 1, FileVisitOption.FOLLOW_LINKS).filter(it -> !Files.isDirectory(it, new LinkOption[0])).map(resourcePath -> new PathResource((Path)resourcePath, PathUtils.toGenericSeparators(this.root.relativize((Path)resourcePath).toString()), this.context)).iterator();
        }
        catch (IOException e) {
            return Collections.emptyIterator();
        }
    }

    @Override
    public Collection<String> getPaths() {
        try {
            return PathResourceLoader.doPrivilegedIfNeeded(this.context, IOException.class, () -> Files.walk(this.root, FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(dir -> {
                String result = this.root.relativize((Path)dir).toString();
                String canonical = PathUtils.toGenericSeparators(result);
                if (canonical.endsWith("/")) {
                    return canonical.substring(0, canonical.length() - 1);
                }
                return canonical;
            }).collect(Collectors.toList()));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public URI getLocation() {
        return PathResourceLoader.doPrivilegedIfNeeded(this.context, this.root::toUri);
    }

    @Override
    public ResourceLoader createSubloader(String relativePath, String rootName) {
        return new PathResourceLoader(rootName, this.root.resolve(PathUtils.relativize(PathUtils.canonicalize(relativePath))), this.context);
    }

    static <T, E extends Throwable> T doPrivilegedIfNeeded(AccessControlContext context, Class<E> exceptionType, PrivilegedExceptionAction<T> action) throws E {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                return action.run();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                if (exceptionType.isInstance(e)) {
                    throw (Throwable)exceptionType.cast(e);
                }
                throw new UndeclaredThrowableException(e);
            }
        }
        try {
            return AccessController.doPrivileged(action, context);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getException();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e1) {
                if (exceptionType.isInstance(e1)) {
                    throw (Throwable)exceptionType.cast(e1);
                }
                throw new UndeclaredThrowableException(e1);
            }
        }
    }

    static <T> T doPrivilegedIfNeeded(AccessControlContext context, PrivilegedExceptionAction<T> action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                return action.run();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        try {
            return AccessController.doPrivileged(action, context);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getException();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e1) {
                throw new UndeclaredThrowableException(e1);
            }
        }
    }
}

