/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.net;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.net.CidrAddress;
import io.smallrye.common.net.Inet;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;

public final class CidrAddressTable<T>
implements Iterable<Mapping<T>> {
    private static final Mapping[] NO_MAPPINGS = new Mapping[0];
    private final AtomicReference<Mapping<T>[]> mappingsRef;

    public CidrAddressTable() {
        this.mappingsRef = new AtomicReference<Mapping<T>[]>(CidrAddressTable.empty());
    }

    private CidrAddressTable(Mapping<T>[] mappings) {
        this.mappingsRef = new AtomicReference<Mapping<T>[]>(mappings);
    }

    public T getOrDefault(InetAddress address, T defVal) {
        Assert.checkNotNullParam("address", address);
        Mapping<T> mapping = this.doGet(this.mappingsRef.get(), address.getAddress(), address instanceof Inet4Address ? 32 : 128, Inet.getScopeId(address));
        return mapping == null ? defVal : mapping.value;
    }

    public T get(InetAddress address) {
        return this.getOrDefault(address, null);
    }

    public T put(CidrAddress block, T value) {
        Assert.checkNotNullParam("block", block);
        Assert.checkNotNullParam("value", value);
        return this.doPut(block, null, value, true, true);
    }

    public T putIfAbsent(CidrAddress block, T value) {
        Assert.checkNotNullParam("block", block);
        Assert.checkNotNullParam("value", value);
        return this.doPut(block, null, value, true, false);
    }

    public T replaceExact(CidrAddress block, T value) {
        Assert.checkNotNullParam("block", block);
        Assert.checkNotNullParam("value", value);
        return this.doPut(block, null, value, false, true);
    }

    public boolean replaceExact(CidrAddress block, T expect, T update) {
        Assert.checkNotNullParam("block", block);
        Assert.checkNotNullParam("expect", expect);
        Assert.checkNotNullParam("update", update);
        return this.doPut(block, expect, update, false, true) == expect;
    }

    public T removeExact(CidrAddress block) {
        Assert.checkNotNullParam("block", block);
        return this.doPut(block, null, null, false, true);
    }

    public boolean removeExact(CidrAddress block, T expect) {
        Assert.checkNotNullParam("block", block);
        return this.doPut(block, expect, null, false, true) == expect;
    }

    private T doPut(CidrAddress block, T expect, T update, boolean putIfAbsent, boolean putIfPresent) {
        boolean matchesExpected;
        T existing;
        Mapping[] newVal;
        Mapping<T>[] oldVal;
        assert (putIfAbsent || putIfPresent);
        AtomicReference<Mapping<T>[]> mappingsRef = this.mappingsRef;
        byte[] bytes = block.getNetworkAddress().getAddress();
        do {
            int idx;
            if ((idx = this.doFind(oldVal = mappingsRef.get(), bytes, block.getNetmaskBits(), block.getScopeId())) < 0) {
                if (!putIfAbsent) {
                    return null;
                }
                existing = null;
            } else {
                existing = oldVal[idx].value;
            }
            if (expect != null) {
                matchesExpected = Objects.equals(expect, existing);
                if (!matchesExpected) {
                    return existing;
                }
            } else {
                matchesExpected = false;
            }
            if (idx >= 0 && !putIfPresent) {
                return existing;
            }
            int oldLen = oldVal.length;
            if (update == null) {
                assert (idx >= 0);
                if (oldLen == 1) {
                    newVal = CidrAddressTable.empty();
                    continue;
                }
                Mapping<T> removing = oldVal[idx];
                newVal = Arrays.copyOf(oldVal, oldLen - 1);
                System.arraycopy(oldVal, idx + 1, newVal, idx, oldLen - idx - 1);
                for (int i = 0; i < oldLen - 1; ++i) {
                    if (newVal[i].parent != removing) continue;
                    newVal[i] = newVal[i].withNewParent(removing.parent);
                }
            } else if (idx >= 0) {
                Mapping<T> newMapping;
                newVal = (Mapping[])oldVal.clone();
                Mapping<T> oldMapping = oldVal[idx];
                newVal[idx] = newMapping = new Mapping<T>(block, update, oldVal[idx].parent);
                for (i = 0; i < oldLen; ++i) {
                    if (i == idx || newVal[i].parent != oldMapping) continue;
                    newVal[i] = newVal[i].withNewParent(newMapping);
                }
            } else {
                Mapping<T> newMapping;
                newVal = Arrays.copyOf(oldVal, oldLen + 1);
                Mapping<T> newMappingParent = this.doGet(oldVal, bytes, block.getNetmaskBits(), block.getScopeId());
                newVal[-idx - 1] = newMapping = new Mapping<T>(block, update, newMappingParent);
                System.arraycopy(oldVal, -idx - 1, newVal, -idx, oldLen + idx + 1);
                for (i = 0; i <= oldLen; ++i) {
                    if (newVal[i] == newMapping || newVal[i].parent != newMappingParent || !block.matches(newVal[i].range)) continue;
                    newVal[i] = newVal[i].withNewParent(newMapping);
                }
            }
        } while (!mappingsRef.compareAndSet(oldVal, newVal));
        return matchesExpected ? expect : existing;
    }

    private static <T> Mapping<T>[] empty() {
        return NO_MAPPINGS;
    }

    public void clear() {
        this.mappingsRef.set(CidrAddressTable.empty());
    }

    public int size() {
        return this.mappingsRef.get().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public CidrAddressTable<T> clone() {
        return new CidrAddressTable<T>(this.mappingsRef.get());
    }

    @Override
    public Iterator<Mapping<T>> iterator() {
        final Mapping[] mappings = this.mappingsRef.get();
        return new Iterator<Mapping<T>>(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx < mappings.length;
            }

            @Override
            public Mapping<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mappings[this.idx++];
            }
        };
    }

    @Override
    public Spliterator<Mapping<T>> spliterator() {
        Object[] mappings = this.mappingsRef.get();
        return Spliterators.spliterator(mappings, 1040);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Mapping<T>[] mappings = this.mappingsRef.get();
        b.append(mappings.length).append(" mappings");
        for (Mapping<T> mapping : mappings) {
            b.append(System.lineSeparator()).append('\t').append(mapping.range);
            if (mapping.parent != null) {
                b.append(" (parent ").append(mapping.parent.range).append(')');
            }
            b.append(" -> ").append(mapping.value);
        }
        return b.toString();
    }

    private int doFind(Mapping<T>[] table, byte[] bytes, int maskBits, int scopeId) {
        int low = 0;
        int high = table.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Mapping<T> mapping = table[mid];
            int cmp = mapping.range.compareAddressBytesTo(bytes, maskBits, scopeId);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private Mapping<T> doGet(Mapping<T>[] table, byte[] bytes, int netmaskBits, int scopeId) {
        int idx = this.doFind(table, bytes, netmaskBits, scopeId);
        if (idx >= 0) {
            assert (table[idx].range.matches(bytes, scopeId));
            return table[idx];
        }
        int pre = -idx - 2;
        if (pre >= 0) {
            if (table[pre].range.matches(bytes, scopeId)) {
                return table[pre];
            }
            Mapping parent = table[pre].parent;
            while (parent != null) {
                if (parent.range.matches(bytes, scopeId)) {
                    return parent;
                }
                parent = parent.parent;
            }
        }
        return null;
    }

    public static final class Mapping<T> {
        final CidrAddress range;
        final T value;
        final Mapping<T> parent;

        Mapping(CidrAddress range, T value, Mapping<T> parent) {
            this.range = range;
            this.value = value;
            this.parent = parent;
        }

        Mapping<T> withNewParent(Mapping<T> newParent) {
            return new Mapping<T>(this.range, this.value, newParent);
        }

        public CidrAddress getRange() {
            return this.range;
        }

        public T getValue() {
            return this.value;
        }

        public Mapping<T> getParent() {
            return this.parent;
        }
    }
}

