/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.StatsEnvelope;

public class TxReadOnlyManyCommand<K, V, R>
extends ReadOnlyManyCommand<K, V, R> {
    public static final byte COMMAND_ID = 65;
    private List<List<Mutation<K, V, ?>>> mutations;

    public TxReadOnlyManyCommand() {
    }

    public TxReadOnlyManyCommand(Collection<?> keys, List<List<Mutation<K, V, ?>>> mutations, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(keys, null, params, keyDataConversion, valueDataConversion, componentRegistry);
        this.mutations = mutations;
        this.init(componentRegistry);
    }

    public TxReadOnlyManyCommand(ReadOnlyManyCommand c, List<List<Mutation<K, V, ?>>> mutations) {
        super(c);
        this.mutations = mutations;
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.mutations != null) {
            for (List<Mutation<K, V, ?>> list : this.mutations) {
                for (Mutation<K, V, ?> m : list) {
                    m.inject(componentRegistry);
                }
            }
        }
    }

    @Override
    public byte getCommandId() {
        return 65;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        int emptyLists = 0;
        for (List<Mutation<K, V, ?>> list : this.mutations) {
            if (list.isEmpty()) {
                ++emptyLists;
                continue;
            }
            if (emptyLists > 0) {
                output.writeInt(-emptyLists);
            }
            output.writeInt(list.size());
            for (Mutation<K, V, ?> mut : list) {
                Mutations.writeTo(output, mut);
            }
            emptyLists = 0;
        }
        if (emptyLists > 0) {
            output.writeInt(-emptyLists);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        int numMutations = this.keys.size();
        this.mutations = new ArrayList(numMutations);
        for (int i = 0; i < numMutations; ++i) {
            int length = input.readInt();
            if (length < 0) {
                i -= length;
                while (length < 0) {
                    this.mutations.add(Collections.emptyList());
                    ++length;
                }
                if (i >= numMutations) break;
                length = input.readInt();
            }
            ArrayList list = new ArrayList(length);
            for (int j = 0; j < length; ++j) {
                list.add(Mutations.readFrom(input));
            }
            this.mutations.add(list);
        }
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.mutations == null) {
            return super.perform(ctx);
        }
        ArrayList<StatsEnvelope> retvals = new ArrayList<StatsEnvelope>(this.keys.size());
        Iterator<List<Mutation<K, V, ?>>> mutIt = this.mutations.iterator();
        boolean skipStats = Param.StatisticsMode.isSkip(this.params);
        for (Object k : this.keys) {
            EntryView.ReadEntryView ro;
            List<Mutation<K, V, ?>> mutations = mutIt.next();
            MVCCEntry entry = (MVCCEntry)this.lookupCacheEntry(ctx, k);
            StatsEnvelope ret = null;
            if (mutations.isEmpty()) {
                ro = entry.isNull() ? EntryViews.noValue(k, this.getKeyDataConversion()) : EntryViews.readOnly(entry, this.keyDataConversion, this.valueDataConversion);
            } else {
                EntryViews.AccessLoggingReadWriteView rw = EntryViews.readWrite(entry, this.keyDataConversion, this.valueDataConversion);
                for (Mutation mutation : mutations) {
                    ret = (StatsEnvelope)mutation.apply(rw);
                    entry.updatePreviousValue();
                }
                ro = rw;
            }
            if (this.f != null) {
                ret = (StatsEnvelope)this.f.apply(ro);
            }
            ret = EntryViews.snapshot(ret);
            retvals.add(skipStats ? ret : StatsEnvelope.create(ret, entry.isNull()));
        }
        return retvals.stream();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TxReadOnlyManyCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", f=").append(this.f);
        sb.append(", mutations=").append(this.mutations);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }
}

