/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.HashSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformerOperationAttachment;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayModel;
import org.jboss.dmr.ModelNode;

public class DeploymentOverlayContentRemove
implements OperationStepHandler {
    private final ContentRepository contentRepository;

    public DeploymentOverlayContentRemove(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        HashSet<PathAddress> removed = (HashSet<PathAddress>)TransformerOperationAttachment.getOrCreate((OperationContext)context).getAttachment(DeploymentOverlayModel.REMOVED_CONTENTS);
        if (removed == null) {
            removed = new HashSet<PathAddress>();
            TransformerOperationAttachment.getOrCreate((OperationContext)context).attach(DeploymentOverlayModel.REMOVED_CONTENTS, removed);
        }
        removed.add(context.getCurrentAddress());
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ModelNode model = context.readResourceFromRoot(address, false).getModel();
        final byte[] hash = model.has("content") ? model.get("content").asBytes() : null;
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction != OperationContext.ResultAction.ROLLBACK && hash != null) {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                    DeploymentOverlayContentRemove.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, hash));
                }
            }
        });
    }
}

