/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.CapabilityServiceNameRegistry;
import org.wildfly.clustering.spi.GroupServiceConfiguratorProvider;
import org.wildfly.clustering.spi.IdentityGroupServiceConfiguratorProvider;
import org.wildfly.clustering.spi.LocalGroupServiceConfiguratorProvider;

public class InfinispanSubsystemServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        InfinispanLogger.ROOT_LOGGER.activatingSubsystem();
        PathAddress address = context.getCurrentAddress();
        ServiceTarget target = context.getServiceTarget();
        CapabilityServiceNameRegistry localRegistry = new CapabilityServiceNameRegistry(InfinispanSubsystemResourceDefinition.LOCAL_CLUSTERING_CAPABILITIES, address);
        for (GroupServiceConfiguratorProvider groupServiceConfiguratorProvider : ServiceLoader.load(LocalGroupServiceConfiguratorProvider.class, LocalGroupServiceConfiguratorProvider.class.getClassLoader())) {
            InfinispanLogger.ROOT_LOGGER.debugf("Installing %s for %s group", groupServiceConfiguratorProvider.getClass().getSimpleName(), "local");
            for (CapabilityServiceConfigurator configurator : groupServiceConfiguratorProvider.getServiceConfigurators((ServiceNameRegistry)localRegistry, "local")) {
                configurator.configure(context).build(target).install();
            }
        }
        if (!context.hasOptionalCapability(JGroupsRequirement.CHANNEL.getDefaultRequirement().getName(), null, null)) {
            CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(InfinispanSubsystemResourceDefinition.CLUSTERING_CAPABILITIES, address);
            for (IdentityGroupServiceConfiguratorProvider provider : ServiceLoader.load(IdentityGroupServiceConfiguratorProvider.class, IdentityGroupServiceConfiguratorProvider.class.getClassLoader())) {
                for (CapabilityServiceConfigurator configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, null, "local")) {
                    configurator.configure(context).build(target).install();
                }
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        CapabilityServiceNameRegistry localRegistry = new CapabilityServiceNameRegistry(InfinispanSubsystemResourceDefinition.LOCAL_CLUSTERING_CAPABILITIES, address);
        for (GroupServiceConfiguratorProvider groupServiceConfiguratorProvider : ServiceLoader.load(LocalGroupServiceConfiguratorProvider.class, LocalGroupServiceConfiguratorProvider.class.getClassLoader())) {
            for (ServiceNameProvider configurator : groupServiceConfiguratorProvider.getServiceConfigurators((ServiceNameRegistry)localRegistry, "local")) {
                context.removeService(configurator.getServiceName());
            }
        }
        if (!context.hasOptionalCapability(JGroupsRequirement.CHANNEL.getDefaultRequirement().getName(), null, null)) {
            CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(InfinispanSubsystemResourceDefinition.CLUSTERING_CAPABILITIES, address);
            for (IdentityGroupServiceConfiguratorProvider provider : ServiceLoader.load(IdentityGroupServiceConfiguratorProvider.class, IdentityGroupServiceConfiguratorProvider.class.getClassLoader())) {
                for (CapabilityServiceConfigurator configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, null, "local")) {
                    context.removeService(configurator.getServiceName());
                }
            }
        }
    }
}

