/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.transaction.impl.XidImpl;

public class XidCodecSupport {
    public static void encodeXid(Xid xid, HornetQBuffer out) {
        out.writeInt(xid.getFormatId());
        out.writeInt(xid.getBranchQualifier().length);
        out.writeBytes(xid.getBranchQualifier());
        out.writeInt(xid.getGlobalTransactionId().length);
        out.writeBytes(xid.getGlobalTransactionId());
    }

    public static Xid decodeXid(HornetQBuffer in) {
        int formatID = in.readInt();
        byte[] bq = new byte[in.readInt()];
        in.readBytes(bq);
        byte[] gtxid = new byte[in.readInt()];
        in.readBytes(gtxid);
        XidImpl xid = new XidImpl(bq, formatID, gtxid);
        return xid;
    }

    public static int getXidEncodeLength(Xid xid) {
        return 12 + xid.getBranchQualifier().length + xid.getGlobalTransactionId().length;
    }
}

