/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.SecurityActions;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ModuleClassLoaderLocator
implements ClassLoaderLocator {
    private final ModuleLoader moduleLoader;
    private final Map<ClassLoader, Map<List<String>, ClassLoader>> combinedClassLoaders;

    public ModuleClassLoaderLocator(ModuleLoader loader) {
        this.moduleLoader = loader;
        this.combinedClassLoaders = new ConcurrentHashMap<ClassLoader, Map<List<String>, ClassLoader>>();
    }

    public ClassLoader get(String key) {
        return this.get(Collections.singletonList(key));
    }

    public ClassLoader get(List<String> modules) {
        ClassLoader TCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        return this.combinedClassLoaders.computeIfAbsent(TCCL, cl -> new ConcurrentHashMap()).computeIfAbsent(modules, ms -> {
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
            try {
                for (String module : modules) {
                    if (module == null || module.isEmpty()) continue;
                    classLoaders.add((ClassLoader)SecurityActions.getModuleClassLoader(this.moduleLoader, module));
                }
                classLoaders.add(TCCL);
            }
            catch (ModuleLoadException e) {
                throw SecurityLogger.ROOT_LOGGER.runtimeException(e);
            }
            return SecurityActions.createCombinedClassLoader(classLoaders);
        });
    }

    public void clearCache() {
        this.combinedClassLoaders.clear();
    }

    public static class CombinedClassLoader
    extends SecureClassLoader {
        private List<ClassLoader> classLoaders;

        public CombinedClassLoader(List<ClassLoader> classLoaders) {
            this.classLoaders = classLoaders;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            for (ClassLoader loader : this.classLoaders) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            ClassLoader loader;
            URL resource = null;
            Iterator<ClassLoader> iterator = this.classLoaders.iterator();
            while (iterator.hasNext() && (resource = (loader = iterator.next()).getResource(name)) == null) {
            }
            return resource;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            ClassLoader loader;
            InputStream is = null;
            Iterator<ClassLoader> iterator = this.classLoaders.iterator();
            while (iterator.hasNext() && (is = (loader = iterator.next()).getResourceAsStream(name)) == null) {
            }
            return is;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> combinedList = new ArrayList<URL>();
            for (ClassLoader loader : this.classLoaders) {
                combinedList.addAll(Collections.list(loader.getResources(name)));
            }
            return Collections.enumeration(combinedList);
        }
    }
}

