/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.stdio;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLoggingWriter
extends Writer {
    private final StringBuilder buffer = new StringBuilder();

    protected AbstractLoggingWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Logger logger = this.getLogger();
        if (logger == null) {
            return;
        }
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            if (c == 10) {
                logger.log(this.getLevel(), this.buffer.toString());
                this.buffer.setLength(0);
            } else {
                this.buffer.append((char)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Logger logger = this.getLogger();
        if (logger == null) {
            return;
        }
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            int i;
            int mark = 0;
            for (i = 0; i < len; ++i) {
                char c = cbuf[off + i];
                if (c != '\n') continue;
                this.buffer.append(cbuf, mark + off, i - mark);
                logger.log(this.getLevel(), this.buffer.toString());
                this.buffer.setLength(0);
                mark = i + 1;
            }
            this.buffer.append(cbuf, mark + off, i - mark);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    protected abstract Logger getLogger();

    protected abstract Level getLevel();

    @Override
    public void close() throws IOException {
    }
}

