/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lifecycle;

import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public enum ComponentStatus {
    INSTANTIATED,
    INITIALIZING,
    RUNNING,
    STOPPING,
    TERMINATED,
    FAILED;

    private static final Log log;

    public boolean needToDestroyFailedCache() {
        return this == FAILED;
    }

    public boolean startAllowed() {
        switch (this) {
            case INSTANTIATED: {
                return true;
            }
        }
        return false;
    }

    public boolean needToInitializeBeforeStart() {
        switch (this) {
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    public boolean stopAllowed() {
        switch (this) {
            case INSTANTIATED: 
            case TERMINATED: 
            case STOPPING: 
            case INITIALIZING: {
                return false;
            }
        }
        return true;
    }

    public boolean allowInvocations() {
        return this == RUNNING;
    }

    public boolean startingUp() {
        return this == INITIALIZING || this == INSTANTIATED;
    }

    public boolean isTerminated() {
        return this == TERMINATED;
    }

    public boolean isStopping() {
        return this == STOPPING;
    }

    static {
        log = LogFactory.getLog(ComponentStatus.class);
    }
}

