/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public abstract class MapExternalizer<T extends Map<Object, Object>, C>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Function<C, T> factory;

    protected MapExternalizer(Class<?> targetClass, Function<C, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T map) throws IOException {
        this.writeContext(output, map);
        IndexSerializer.VARIABLE.writeInt(output, map.size());
        for (Map.Entry entry : map.entrySet()) {
            output.writeObject(entry.getKey());
            output.writeObject(entry.getValue());
        }
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        C context = this.readContext(input);
        Map map = (Map)this.factory.apply(context);
        int size = IndexSerializer.VARIABLE.readInt(input);
        for (int i = 0; i < size; ++i) {
            map.put(input.readObject(), input.readObject());
        }
        return (T)map;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    protected abstract void writeContext(ObjectOutput var1, T var2) throws IOException;

    protected abstract C readContext(ObjectInput var1) throws IOException, ClassNotFoundException;
}

